package org.mule.metadata.dw;

import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

import java.io.File;

public abstract class DwBasedShapeTypeLoader extends DwBasedTypeLoader {

  public DwBasedShapeTypeLoader(File file,
                                ExpressionLanguageMetadataService expressionLanguageMetadataService) {
    super(file, expressionLanguageMetadataService);
  }

  public DwBasedShapeTypeLoader(String content,
                                ExpressionLanguageMetadataService expressionLanguageMetadataService) {
    super(content, expressionLanguageMetadataService);
  }

  @Override
  protected TypeLoader createTypeLoader(File file, MetadataFormat metadataFormat) {
    return new DwShapeTypeLoader(file, metadataFormat, getExpressionLanguageMetadataService());
  }

  @Override
  protected TypeLoader createTypeLoader(String content, MetadataFormat metadataFormat) {
    return new DwShapeTypeLoader(content, metadataFormat, getExpressionLanguageMetadataService());
  }
}
