package org.mule.metadata.raml;

import com.google.common.base.Throwables;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.raml.handler.ParsingContext;
import org.mule.metadata.raml.handler.TypeDeclarationHandlerManager;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.model.v10.api.Library;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

import java.io.File;
import java.util.List;
import java.util.Optional;

public class RamlTypeLibTypeLoader extends BaseRamlTypeLoader {

  private File ramlTypeLibFile;
  private MetadataFormat metadataFormat;

  public RamlTypeLibTypeLoader(File ramlTypeLibFile, MetadataFormat metadataFormat) {
    this.ramlTypeLibFile = ramlTypeLibFile;
    this.metadataFormat = metadataFormat;
  }

  @Override
  public Optional<MetadataType> load(String typeIdentifier) {
    return load(typeIdentifier, null);
  }


  @Override
  public Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
    try {
      final RamlModelResult ramlModelResult = RamlModelBuilderFactory.INSTANCE.createRamlModelBuilder().buildApi(ramlTypeLibFile);
      List<TypeDeclaration> types = null;
      final Library library = ramlModelResult.getLibrary();
      if (library != null) {
        types = library.types();
      }
      if (types == null) {
        String validationErrors = collectValidationErrors(ramlModelResult);
        throw new IllegalArgumentException(validationErrors);
      }
      return Optional.ofNullable(types.stream()
          .filter(typeDeclaration -> typeDeclaration.name().equals(typeIdentifier))
          .findFirst()
          .map(typeDeclaration -> {
            final TypeDeclarationHandlerManager typeDeclarationHandlerManager =
                new TypeDeclarationHandlerManager(metadataFormat);
            final TypeBuilder<?> typeBuilder =
                typeDeclarationHandlerManager.handle(typeDeclaration, new ParsingContext());
            MetadataTypeUtils.addTypeAlias(typeBuilder, typeAlias);
            return typeBuilder.build();
          }).orElse(null));
    } catch (Exception e) {
      throw Throwables.propagate(e);
    }
  }
}
