/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.declarations.loader.xml;

import com.google.common.base.Throwables;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.datasense.catalog.model.resolver.TypeResolverException;
import org.mule.datasense.common.loader.xml.XmlMatcher;
import org.mule.datasense.common.util.TypeUtils;
import org.mule.datasense.declarations.loader.AbstractTypeDeclarationLoader;
import org.mule.datasense.declarations.loader.TypeDeclarationLoaderContext;
import org.mule.datasense.declarations.model.ExtensionOperationTypeDeclaration;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.FunctionTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.message.MessageMetadataTypeBuilder;
import org.w3c.dom.Element;

public class ExtensionOperationTypeDeclarationXmlLoader
extends AbstractTypeDeclarationLoader<ExtensionOperationTypeDeclaration, Element> {
    private static final String NS_MULE = "http://www.mulesoft.org/schema/mule/types";
    private static final String NS_TYPES = "http://www.mulesoft.org/schema/mule/types";
    private static final QName ELEM_MULE = new QName("http://www.mulesoft.org/schema/mule/types", "mule");
    private static final QName ELEM_OP_DECLARATION = new QName("http://www.mulesoft.org/schema/mule/types", "operation-declaration");
    private static final QName ELEM_INPUTS = new QName("http://www.mulesoft.org/schema/mule/types", "inputs");
    private static final QName ELEM_OUTPUTS = new QName("http://www.mulesoft.org/schema/mule/types", "outputs");
    private static final QName ELEM_PAYLOAD = new QName("http://www.mulesoft.org/schema/mule/types", "payload");
    private static final QName ELEM_ATTRIBUTES = new QName("http://www.mulesoft.org/schema/mule/types", "attributes");
    private static final QName ELEM_PARAMETER = new QName("http://www.mulesoft.org/schema/mule/types", "parameter");
    private static final String ATTR_NAME = "name";
    private static final String ATTR_TYPE = "type";

    @Override
    public Optional<ExtensionOperationTypeDeclaration> load(Element element, TypeDeclarationLoaderContext typeDeclarationLoaderContext) {
        return XmlMatcher.match(element, ELEM_OP_DECLARATION).map(opDeclaration -> {
            BaseTypeBuilder typeBuilder = TypeUtils.getTypeBuilder(MetadataFormat.JAVA);
            FunctionTypeBuilder functionTypeBuilder = typeBuilder.functionType();
            opDeclaration.match(ELEM_INPUTS).ifPresent(inputs -> inputs.matchMany(ELEM_PARAMETER).forEach(parameterMatcher -> {
                String name = parameterMatcher.requireAttribute(ATTR_NAME);
                String typeExpression = parameterMatcher.requireAttribute(ATTR_TYPE);
                try {
                    functionTypeBuilder.addParameterOf(name, this.resolveType(typeExpression, typeDeclarationLoaderContext.getTypesCatalog()));
                }
                catch (TypeResolverException e) {
                    Throwables.propagate((Throwable)e);
                }
            }));
            opDeclaration.match(ELEM_OUTPUTS).ifPresent(outputs -> {
                MessageMetadataTypeBuilder messageMetadataTypeBuilder = new MessageMetadataTypeBuilder();
                outputs.match(ELEM_PAYLOAD).ifPresent(payloadMatcher -> {
                    String typeExpression = payloadMatcher.requireAttribute(ATTR_TYPE);
                    try {
                        messageMetadataTypeBuilder.payload(this.resolveType(typeExpression, typeDeclarationLoaderContext.getTypesCatalog()));
                    }
                    catch (TypeResolverException e) {
                        Throwables.propagate((Throwable)e);
                    }
                });
                outputs.match(ELEM_ATTRIBUTES).ifPresent(attributesMatcher -> {
                    String typeExpression = attributesMatcher.requireAttribute(ATTR_TYPE);
                    try {
                        messageMetadataTypeBuilder.attributes(this.resolveType(typeExpression, typeDeclarationLoaderContext.getTypesCatalog()));
                    }
                    catch (TypeResolverException e) {
                        Throwables.propagate((Throwable)e);
                    }
                });
                functionTypeBuilder.returnType((TypeBuilder)messageMetadataTypeBuilder);
            });
            return new ExtensionOperationTypeDeclaration(functionTypeBuilder.build());
        });
    }
}

