/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.catalog.builder;

import com.google.common.base.Throwables;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.mule.datasense.catalog.builder.TypesCatalogBuilderContext;
import org.mule.datasense.catalog.builder.TypesResolverBuilder;
import org.mule.datasense.catalog.model.TypesCatalog;
import org.mule.datasense.catalog.util.NotificationMessages;
import org.mule.datasense.common.util.Notifier;

public class TypesCatalogBuilder {
    private final List<TypesResolverBuilder> typesResolverBuilders;
    private URI baseUri;
    private final TypesCatalogBuilderContext typesCatalogBuilderContext;

    public TypesCatalogBuilder(URI baseUri, TypesCatalogBuilderContext typesCatalogBuilderContext) {
        this.baseUri = baseUri;
        this.typesCatalogBuilderContext = typesCatalogBuilderContext;
        this.typesResolverBuilders = new ArrayList<TypesResolverBuilder>();
    }

    public void addTypesResolver(Consumer<TypesResolverBuilder> typesResolverBuilderConsumer) {
        TypesResolverBuilder typesResolverBuilder = new TypesResolverBuilder(this.baseUri);
        typesResolverBuilderConsumer.accept(typesResolverBuilder);
        this.typesResolverBuilders.add(typesResolverBuilder);
    }

    public TypesCatalog build() throws Exception {
        return new TypesCatalog(this.typesResolverBuilders.stream().map(typesResolverBuilder -> {
            try {
                return typesResolverBuilder.build();
            }
            catch (Exception e) {
                Optional<Notifier> notifierOptional = this.typesCatalogBuilderContext.getNotifier();
                if (notifierOptional.isPresent()) {
                    notifierOptional.get().reportError(NotificationMessages.MSG_FAILED_TO_DECLARE_TYPE_ON_CATALOG(typesResolverBuilder.getName(), e));
                } else {
                    Throwables.propagate((Throwable)e);
                }
                return null;
            }
        }).filter(typeResolver -> typeResolver != null).collect(Collectors.toList()));
    }
}

