/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.declarations.loader.xml;

import com.google.common.base.Throwables;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.datasense.catalog.model.resolver.TypeResolverException;
import org.mule.datasense.common.loader.xml.XmlMatcher;
import org.mule.datasense.common.util.Notifier;
import org.mule.datasense.common.util.TypeUtils;
import org.mule.datasense.declarations.loader.AbstractTypeDeclarationLoader;
import org.mule.datasense.declarations.loader.TypeDeclarationLoaderContext;
import org.mule.datasense.declarations.model.MessageProcessorTypeDeclaration;
import org.mule.datasense.declarations.util.NotificationMessages;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.FunctionTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.message.MessageMetadataTypeBuilder;
import org.mule.metadata.message.MuleEventMetadataTypeBuilder;
import org.w3c.dom.Element;

public class MessageProcessorTypeDeclarationXmlLoader
extends AbstractTypeDeclarationLoader<MessageProcessorTypeDeclaration, Element> {
    private static final String NS_MULE = "http://www.mulesoft.org/schema/mule/types";
    private static final String NS_TYPES = "http://www.mulesoft.org/schema/mule/types";
    private static final QName ELEM_MP_DECLARATION = new QName("http://www.mulesoft.org/schema/mule/types", "processor-declaration");
    private static final QName ELEM_INPUT_EVENT = new QName("http://www.mulesoft.org/schema/mule/types", "input-event");
    private static final QName ELEM_OUTPUT_EVENT = new QName("http://www.mulesoft.org/schema/mule/types", "output-event");
    private static final QName ELEM_MESSAGE = new QName("http://www.mulesoft.org/schema/mule/types", "message");
    private static final QName ELEM_PAYLOAD = new QName("http://www.mulesoft.org/schema/mule/types", "payload");
    private static final String ATTR_TYPE = "type";
    private static final QName ELEM_ATTRIBUTES = new QName("http://www.mulesoft.org/schema/mule/types", "attributes");
    private static final QName ELEM_VARIABLES = new QName("http://www.mulesoft.org/schema/mule/types", "variables");
    private static final QName ELEM_VARIABLE = new QName("http://www.mulesoft.org/schema/mule/types", "variable");
    private static final String ATTR_NAME = "name";
    private static final String PARAMETER_NAME = "input";

    @Override
    public Optional<MessageProcessorTypeDeclaration> load(Element element, TypeDeclarationLoaderContext typeDeclarationLoaderContext) {
        return XmlMatcher.match(element, ELEM_MP_DECLARATION).map(opDeclaration -> {
            BaseTypeBuilder typeBuilder = TypeUtils.getTypeBuilder(MetadataFormat.JAVA);
            FunctionTypeBuilder functionTypeBuilder = typeBuilder.functionType();
            opDeclaration.match(ELEM_INPUT_EVENT).ifPresent(inputEvent -> {
                MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
                functionTypeBuilder.addParameterOf(PARAMETER_NAME, (TypeBuilder)muleEventMetadataTypeBuilder);
                this.loadEventMetadataType(muleEventMetadataTypeBuilder, (XmlMatcher)inputEvent, typeDeclarationLoaderContext);
            });
            opDeclaration.match(ELEM_OUTPUT_EVENT).ifPresent(outputEvent -> {
                MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
                functionTypeBuilder.returnType((TypeBuilder)muleEventMetadataTypeBuilder);
                this.loadEventMetadataType(muleEventMetadataTypeBuilder, (XmlMatcher)outputEvent, typeDeclarationLoaderContext);
            });
            return new MessageProcessorTypeDeclaration(functionTypeBuilder.build());
        });
    }

    private void loadEventMetadataType(MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder, XmlMatcher eventComponentModelMatcher, TypeDeclarationLoaderContext typeDeclarationLoaderContext) {
        MessageMetadataTypeBuilder messageMetadataTypeBuilder = new MessageMetadataTypeBuilder();
        muleEventMetadataTypeBuilder.message(messageMetadataTypeBuilder);
        eventComponentModelMatcher.match(ELEM_MESSAGE).ifPresent(messageMatcher -> {
            messageMatcher.match(ELEM_PAYLOAD).ifPresent(payloadMatcher -> {
                String typeExpression = payloadMatcher.requireAttribute(ATTR_TYPE);
                try {
                    messageMetadataTypeBuilder.payload(this.resolveType(typeExpression, typeDeclarationLoaderContext.getTypesCatalog()));
                }
                catch (TypeResolverException e) {
                    Optional<Notifier> notifierOptional = typeDeclarationLoaderContext.getNotifier();
                    if (notifierOptional.isPresent()) {
                        notifierOptional.get().reportError(NotificationMessages.MSG_FAILED_TO_RESOLVE_TYPE_EXPRESSION("message payload", typeExpression, typeDeclarationLoaderContext.getComponentModel(), e));
                    }
                    Throwables.propagate((Throwable)e);
                }
            });
            messageMatcher.match(ELEM_ATTRIBUTES).ifPresent(attributesMatcher -> {
                String typeExpression = attributesMatcher.requireAttribute(ATTR_TYPE);
                try {
                    messageMetadataTypeBuilder.attributes(this.resolveType(typeExpression, typeDeclarationLoaderContext.getTypesCatalog()));
                }
                catch (TypeResolverException e) {
                    Optional<Notifier> notifierOptional = typeDeclarationLoaderContext.getNotifier();
                    if (notifierOptional.isPresent()) {
                        notifierOptional.get().reportError(NotificationMessages.MSG_FAILED_TO_RESOLVE_TYPE_EXPRESSION("message attributes", typeExpression, typeDeclarationLoaderContext.getComponentModel(), e));
                    }
                    Throwables.propagate((Throwable)e);
                }
            });
        });
        eventComponentModelMatcher.match(ELEM_VARIABLES).ifPresent(variablesMatcher -> variablesMatcher.matchMany(ELEM_VARIABLE).forEach(variableMatcher -> {
            String name = variableMatcher.requireAttribute(ATTR_NAME);
            String typeExpression = variableMatcher.requireAttribute(ATTR_TYPE);
            try {
                muleEventMetadataTypeBuilder.addVariable(name, this.resolveType(typeExpression, typeDeclarationLoaderContext.getTypesCatalog()));
            }
            catch (TypeResolverException e) {
                Optional<Notifier> notifierOptional = typeDeclarationLoaderContext.getNotifier();
                if (notifierOptional.isPresent()) {
                    notifierOptional.get().reportError(NotificationMessages.MSG_FAILED_TO_RESOLVE_TYPE_EXPRESSION("variable " + name, typeExpression, typeDeclarationLoaderContext.getComponentModel(), e));
                }
                Throwables.propagate((Throwable)e);
            }
        }));
    }
}

