package org.mule.datasense.catalog.loader;

import org.mule.datasense.catalog.builder.TypesCatalogBuilder;
import org.mule.datasense.catalog.builder.TypesCatalogBuilderContext;
import org.mule.datasense.catalog.model.TypesCatalog;

import java.io.File;
import java.net.URI;

public abstract class BaseTypesCatalogLoader implements TypesCatalogLoader {

  @Override
  public TypesCatalog load(File file, TypesCatalogBuilderContext typesCatalogBuilderContext) throws Exception {
    TypesCatalogBuilder typesCatalogBuilder = new TypesCatalogBuilder(file.toURI(), typesCatalogBuilderContext);
    TypesCatalogLoaderContext typesCatalogLoaderContext = new TypesCatalogLoaderContext(typesCatalogBuilder);
    load(file, typesCatalogLoaderContext);
    return typesCatalogBuilder.build();
  }

  @Override
  public TypesCatalog load(String data, TypesCatalogBuilderContext typesCatalogBuilderContext, URI baseURI) throws Exception {
    TypesCatalogBuilder typesCatalogBuilder = new TypesCatalogBuilder(baseURI, typesCatalogBuilderContext);
    TypesCatalogLoaderContext typesCatalogLoaderContext = new TypesCatalogLoaderContext(typesCatalogBuilder);
    load(data, typesCatalogLoaderContext);
    return typesCatalogBuilder.build();
  }

  protected abstract void load(File file, TypesCatalogLoaderContext typesCatalogLoaderContext);

  protected abstract void load(String data, TypesCatalogLoaderContext typesCatalogLoaderContext);
}
