package org.mule.datasense.catalog.model.resolver.loaders;

import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.csv.CsvExampleTypeLoader;

import java.io.File;

public class CsvExampleTypeLoaderFactory implements ExampleTypeLoaderFactory {

  @Override
  public String getTypeFormat() {
    return MetadataFormat.CSV.getId();
  }

  @Override
  public String getLoaderFormat() {
    return MetadataFormat.CSV.getId();
  }

  @Override
  public TypeLoader createTypeLoader(File file) {
    return new CsvExampleTypeLoader(file);
  }

  @Override
  public TypeLoader createTypeLoader(String content) {
    return new CsvExampleTypeLoader(content);
  }
}
