package org.mule.datasense.catalog.model.resolver.loaders;

import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.xml.ModelFactory;
import org.mule.metadata.xml.XmlTypeLoader;

import java.io.File;

public class XmlTypeLoaderFactory implements ExampleTypeLoaderFactory {

  @Override
  public String getTypeFormat() {
    return MetadataFormat.XML.getId();
  }

  @Override
  public String getLoaderFormat() {
    return "xml";
  }

  @Override
  public TypeLoader createTypeLoader(File file) {
    return new XmlTypeLoader(ModelFactory.fromExample(file));
  }

  @Override
  public TypeLoader createTypeLoader(String content) {
    return new XmlTypeLoader(ModelFactory.fromExample(content));
  }
}
