package org.mule.datasense.enrichment.loader.xml;

import org.mule.datasense.common.loader.xml.XmlMatcher;
import org.mule.datasense.enrichment.loader.ComponentModelEnrichmentLoader;
import org.mule.datasense.enrichment.loader.ComponentModelEnrichmentLoaderContext;
import org.mule.datasense.enrichment.model.ComponentModelEnrichment;
import org.mule.datasense.enrichment.model.ComponentModelEnrichments;
import org.mule.datasense.enrichment.model.ComponentModelSelector;
import org.mule.datasense.enrichment.model.ComponentModelSelectors;
import org.w3c.dom.Element;

import javax.xml.namespace.QName;
import java.util.Optional;

public class ComponentModelEnrichmentXmlLoader extends ComponentModelEnrichmentLoader<Element> {

  private static final String NS_TYPES = "http://www.mulesoft.org/schema/mule/types";
  private static final QName ELEM_MULE = new QName(NS_TYPES, "mule");
  private static final QName ELEM_ENRICHMENT = new QName(NS_TYPES, "enrichment");

  @Override
  public Optional<ComponentModelEnrichments> load(Element element,
                                                  ComponentModelEnrichmentLoaderContext componentModelEnrichmentLoaderContext) {
    return XmlMatcher.match(element, ELEM_MULE).map(xmlMatcher -> {
      final ComponentModelEnrichments componentModelEnrichments = new ComponentModelEnrichments();
      xmlMatcher.matchMany(ELEM_ENRICHMENT).forEach(enrichment -> {
        final String select = enrichment.requireAttribute("select");
        final ComponentModelSelector componentModelSelector =
            ComponentModelSelectors.create(select);
        enrichment.matchFirst().ifPresent(value -> {
          componentModelEnrichments.add(new ComponentModelEnrichment(componentModelSelector, value.element()));
        });
      });
      return componentModelEnrichments;
    });
  }
}
