package org.mule.datasense.enrichment.model;

import org.mule.runtime.config.spring.api.dsl.model.ComponentModel;

import java.util.Optional;

public class ComponentModelEnrichment {

  private final ComponentModelSelector componentModelSelector;
  private final Object enrichmentComponentModel;

  public ComponentModelEnrichment(ComponentModelSelector componentModelSelector, Object enrichmentComponentModel) {
    this.componentModelSelector = componentModelSelector;
    this.enrichmentComponentModel = enrichmentComponentModel;
  }

  public Optional<Object> enrich(ComponentModel componentModel) {
    return componentModelSelector.match(componentModel) ? Optional.of(enrichmentComponentModel) : Optional.empty();
  }
}
