package org.mule.datasense.enrichment.model;

import org.mule.runtime.config.spring.api.dsl.model.ComponentModel;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public class ComponentModelEnrichments {

  private final List<ComponentModelEnrichment> componentModelEnrichmentList;

  public ComponentModelEnrichments() {
    componentModelEnrichmentList = new ArrayList<>();
  }

  public void add(ComponentModelEnrichment componentModelEnrichment) {
    componentModelEnrichmentList.add(componentModelEnrichment);
  }

  public Stream<ComponentModelEnrichment> getModelEnrichments() {
    return componentModelEnrichmentList.stream();
  }

  public Stream<Object> enrich(ComponentModel componentModel) {
    return componentModelEnrichmentList.stream()
        .map(componentModelEnrichment -> componentModelEnrichment.enrich(componentModel))
        .filter(Optional::isPresent)
        .map(Optional::get);
  }
}
