package org.mule.datasense.declarations.loader;

import org.apache.commons.lang3.StringUtils;
import org.mule.datasense.catalog.model.TypesCatalog;
import org.mule.datasense.catalog.model.resolver.TypeResolverException;
import org.mule.datasense.common.util.TypeUtils;
import org.mule.datasense.declarations.loader.xml.TypeDeclarationXmlLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

import java.util.Optional;

public abstract class AbstractTypeDeclarationLoader<T, U> implements TypeDeclarationXmlLoader<T, U> {

  public abstract Optional<T> load(U object, TypeDeclarationLoaderContext typeDeclarationLoaderContext);

  protected MetadataType resolveType(String typeExpression, TypesCatalog typesCatalog) throws TypeResolverException {
    MetadataType result = null;
    String currentTypeExpression = typeExpression;
    boolean useArray = false;
    if (currentTypeExpression.endsWith("[]")) {
      useArray = true;
      currentTypeExpression = StringUtils.removeEnd(currentTypeExpression, "[]");
    }
    String typeIdentifier = currentTypeExpression;
    result = typesCatalog.resolveType(typeIdentifier).orElseThrow(() -> new TypeResolverException(String
        .format(
                "Failed to resolve type %s in expression %s.",
                typeIdentifier,
                typeExpression)));
    if (useArray) {
      final BaseTypeBuilder typeBuilder = TypeUtils.getTypeBuilder(MetadataFormat.JAVA);
      result = typeBuilder.arrayType().of(result).build();
    }
    return result;
  }
}
