package org.mule.datasense.enrichment.model;

import org.mule.runtime.config.internal.model.ComponentModel;

import com.google.common.base.Preconditions;

public class IdComponentModelSelector implements ComponentModelSelector {

  final static String PREFIX = "#";

  private final String id;

  public IdComponentModelSelector(String id) {
    Preconditions.checkNotNull(id);
    this.id = id;
  }

  @Override
  public boolean match(ComponentModel componentModel) {
    // @todo should be using namespace uris
    return id.equals(getComponentId(componentModel));
  }

  public static String getComponentId(ComponentModel componentModel) {
    return componentModel.getParameters().get("doc:id");
  }
}
