package org.mule.datasense.enrichment.model;

import org.mule.runtime.config.internal.model.ComponentModel;

import com.google.common.base.Preconditions;

public class PathComponentModelSelector implements ComponentModelSelector {

  final static String PREFIX = "@";

  private final String location;

  public PathComponentModelSelector(String location) {
    Preconditions.checkNotNull(location);
    this.location = location;
  }

  @Override
  public boolean match(ComponentModel componentModel) {
    return location.equals(getLocation(componentModel));
  }

  public static String getLocation(ComponentModel componentModel) {
    return componentModel.getComponentLocation().getLocation();
  }
}
