package org.mule.datasense.catalog.model.resolver.loaders;

import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.excel.ExcelExampleTypeLoader;

import java.io.File;

public class ExcelExampleTypeLoaderFactory implements ExampleTypeLoaderFactory {

  @Override
  public String getTypeFormat() {
    return MetadataFormats.EXCEL.getId();
  }

  @Override
  public String getLoaderFormat() {
    return MetadataFormats.EXCEL.getId();
  }

  @Override
  public TypeLoader createTypeLoader(File file) {
    return new ExcelExampleTypeLoader(file);
  }

  @Override
  public TypeLoader createTypeLoader(String content) {
    return new ExcelExampleTypeLoader(content);
  }
}
