package org.mule.datasense.catalog.model.resolver.loaders;

import com.google.common.base.Preconditions;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.dw.DwBasedShapeTypeLoader;

import java.io.File;

public class FromDwShapeTypeLoaderFactory implements ShapeTypeLoaderFactory {

  private MetadataFormat format;

  public FromDwShapeTypeLoaderFactory(MetadataFormat format) {
    Preconditions.checkNotNull(format);
    this.format = format;
  }

  @Override
  public String getTypeFormat() {
    return format.getId();
  }

  @Override
  public String getLoaderFormat() {
    return MetadataFormats.DW.getId();
  }

  @Override
  public TypeLoader createTypeLoader(File file) {
    return new DwBasedShapeTypeLoader(file) {

      @Override
      protected MetadataFormat getMetadataFormat() {
        return format;
      }
    };
  }

  @Override
  public TypeLoader createTypeLoader(String content) {
    return new DwBasedShapeTypeLoader(content) {

      @Override
      protected MetadataFormat getMetadataFormat() {
        return format;
      }
    };
  }
}
