/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.catalog.model.resolver;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.mule.datasense.catalog.model.resolver.TypeResolver;
import org.mule.datasense.catalog.model.resolver.loaders.CopybookTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.CsvFromDwShapeTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.CsvTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.ExcelFromDwShapeTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.FixedWidthTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.FlatFileTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.FromDwShapeTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.JavaFromDwShapeTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.JavaTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.JsonSchemaTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.MapTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.ShapeTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.TypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.TypeLoaderRegistry;
import org.mule.datasense.catalog.model.resolver.loaders.XmlSchemaTypeLoaderFactory;
import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;

public class ShapeTypeResolver
implements TypeResolver {
    private static TypeLoaderRegistry typeLoaderRegistry = new TypeLoaderRegistry(ShapeTypeLoaderFactory.class);
    private String typeIdentifier;
    private String format;
    private final TypeLoader typeLoader;

    ShapeTypeResolver(String typeIdentifier, String format, TypeLoader typeLoader) {
        Preconditions.checkNotNull((Object)typeLoader);
        Preconditions.checkNotNull((Object)format);
        Preconditions.checkNotNull((Object)typeIdentifier);
        this.format = format;
        this.typeLoader = typeLoader;
        this.typeIdentifier = typeIdentifier;
    }

    private static TypeLoaderFactory getTypeLoaderFactory(String typeFormat, String shapeFormat) {
        TypeLoaderFactory typeLoaderFactory = typeLoaderRegistry.getFactory(typeFormat, shapeFormat).orElseThrow(() -> new RuntimeException(String.format("Unsupported typeFormat %s shapeFormat %s", typeFormat, shapeFormat)));
        return typeLoaderFactory;
    }

    public static ShapeTypeResolver createFromUrl(String typeFormat, String typeIdentifier, String shapeFormat, URL schemaUrl, String element) {
        return new ShapeTypeResolver(typeIdentifier, shapeFormat, ShapeTypeResolver.getTypeLoaderFactory(typeFormat, shapeFormat).createTypeLoader(FileUtils.toFile((URL)schemaUrl)));
    }

    public static ShapeTypeResolver createFromContent(String typeFormat, String typeIdentifier, String shapeFormat, String content) {
        return new ShapeTypeResolver(typeIdentifier, shapeFormat, ShapeTypeResolver.getTypeLoaderFactory(typeFormat, shapeFormat).createTypeLoader(content));
    }

    @Override
    public Optional<MetadataType> resolveType(String typeIdentifier) {
        return this.typeLoader.load(this.typeIdentifier, typeIdentifier);
    }

    static {
        typeLoaderRegistry.register(new JsonSchemaTypeLoaderFactory());
        typeLoaderRegistry.register(new XmlSchemaTypeLoaderFactory());
        typeLoaderRegistry.register(new JavaTypeLoaderFactory());
        typeLoaderRegistry.register(new CsvTypeLoaderFactory());
        typeLoaderRegistry.register(new MapTypeLoaderFactory());
        typeLoaderRegistry.register(new CopybookTypeLoaderFactory());
        typeLoaderRegistry.register(new FixedWidthTypeLoaderFactory());
        typeLoaderRegistry.register(new FlatFileTypeLoaderFactory());
        typeLoaderRegistry.register(new CsvFromDwShapeTypeLoaderFactory());
        typeLoaderRegistry.register(new ExcelFromDwShapeTypeLoaderFactory());
        typeLoaderRegistry.register(new JavaFromDwShapeTypeLoaderFactory());
        typeLoaderRegistry.register(new FromDwShapeTypeLoaderFactory(MetadataFormats.XML));
        typeLoaderRegistry.register(new FromDwShapeTypeLoaderFactory(MetadataFormats.JSON));
    }
}

