/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.types.parser;

import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mule.datasense.types.parser.Parser;

public class Parsers {
    public static Object unit = new Object();

    public static Parser<?> empty() {
        return Parsers.success(unit);
    }

    public static <B> Parser<B> success(B value) {
        return in -> value;
    }

    public static <B> Parser<B> failure(String cause) {
        return in -> {
            throw Failure.exception;
        };
    }

    @SafeVarargs
    public static <B> Parser<B> choice(Parser<B> parser, Parser<B> ... parsers) {
        return Arrays.asList(parsers).stream().reduce(parser, Parser::or);
    }

    public static SkipParser skip(Parser<?> parser) {
        return new SkipParser(parser);
    }

    public static <B> Parser<B> then(Supplier<Parser<B>> parser) {
        return in -> ((Parser)parser.get()).parse(in);
    }

    public static Parser<?> begin() {
        return Parsers.regex("^").map(m -> unit);
    }

    public static Parser<?> end() {
        return Parsers.regex("$").map(m -> unit);
    }

    public static Parser<String> string(String string) {
        return Parsers.regex(Pattern.quote(string)).map(MatchResult::group);
    }

    public static Parser<MatchResult> regex(String regex) {
        return Parsers.regex(Pattern.compile(regex));
    }

    public static Parser<MatchResult> regex(Pattern pattern) {
        return new RegexParser(pattern);
    }

    public static <A, R> Function<A, R> match(Function<A, R> f) {
        return f;
    }

    public static <A, B, R> Function<Pair<A, B>, R> match(BiFunction<A, B, R> f) {
        return p -> f.apply(p.first, p.second);
    }

    public static <A, B, C, R> Function<Pair<Pair<A, B>, C>, R> match(Function3<A, B, C, R> f) {
        return p -> f.apply(((Pair)p.first).first, ((Pair)p.first).second, p.second);
    }

    public static <A, B, C, D, R> Function<Pair<Pair<Pair<A, B>, C>, D>, R> match(Function4<A, B, C, D, R> f) {
        return p -> f.apply(((Pair)((Pair)p.first).first).first, ((Pair)((Pair)p.first).first).second, ((Pair)p.first).second, p.second);
    }

    public static <A, B, C, D, E, R> Function<Pair<Pair<Pair<Pair<A, B>, C>, D>, E>, R> match(Function5<A, B, C, D, E, R> f) {
        return p -> f.apply(((Pair)((Pair)((Pair)p.first).first).first).first, ((Pair)((Pair)((Pair)p.first).first).first).second, ((Pair)((Pair)p.first).first).second, ((Pair)p.first).second, p.second);
    }

    public static <A, B, C, D, E, F, R> Function<Pair<Pair<Pair<Pair<Pair<A, B>, C>, D>, E>, F>, R> match(Function6<A, B, C, D, E, F, R> f) {
        return p -> f.apply(((Pair)((Pair)((Pair)((Pair)p.first).first).first).first).first, ((Pair)((Pair)((Pair)((Pair)p.first).first).first).first).second, ((Pair)((Pair)((Pair)p.first).first).first).second, ((Pair)((Pair)p.first).first).second, ((Pair)p.first).second, p.second);
    }

    public static <A, B, C, D, E, F, G, R> Function<Pair<Pair<Pair<Pair<Pair<Pair<A, B>, C>, D>, E>, F>, G>, R> match(Function7<A, B, C, D, E, F, G, R> f) {
        return p -> f.apply(((Pair)((Pair)((Pair)((Pair)((Pair)p.first).first).first).first).first).first, ((Pair)((Pair)((Pair)((Pair)((Pair)p.first).first).first).first).first).second, ((Pair)((Pair)((Pair)((Pair)p.first).first).first).first).second, ((Pair)((Pair)((Pair)p.first).first).first).second, ((Pair)((Pair)p.first).first).second, ((Pair)p.first).second, p.second);
    }

    public static <A, B, C, D, E, F, G, H, R> Function<Pair<Pair<Pair<Pair<Pair<Pair<Pair<A, B>, C>, D>, E>, F>, G>, H>, R> match(Function8<A, B, C, D, E, F, G, H, R> f) {
        return p -> f.apply(((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)p.first).first).first).first).first).first).first, ((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)p.first).first).first).first).first).first).second, ((Pair)((Pair)((Pair)((Pair)((Pair)p.first).first).first).first).first).second, ((Pair)((Pair)((Pair)((Pair)p.first).first).first).first).second, ((Pair)((Pair)((Pair)p.first).first).first).second, ((Pair)((Pair)p.first).first).second, ((Pair)p.first).second, p.second);
    }

    public static <A, B, C, D, E, F, G, H, I, R> Function<Pair<Pair<Pair<Pair<Pair<Pair<Pair<Pair<A, B>, C>, D>, E>, F>, G>, H>, I>, R> match(Function9<A, B, C, D, E, F, G, H, I, R> f) {
        return p -> f.apply(((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)p.first).first).first).first).first).first).first).first, ((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)p.first).first).first).first).first).first).first).second, ((Pair)((Pair)((Pair)((Pair)((Pair)((Pair)p.first).first).first).first).first).first).second, ((Pair)((Pair)((Pair)((Pair)((Pair)p.first).first).first).first).first).second, ((Pair)((Pair)((Pair)((Pair)p.first).first).first).first).second, ((Pair)((Pair)((Pair)p.first).first).first).second, ((Pair)((Pair)p.first).first).second, ((Pair)p.first).second, p.second);
    }

    public static class RegexParser
    implements Parser<MatchResult> {
        private Pattern pattern;

        public RegexParser(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public MatchResult parse(Input in) throws Failure {
            Matcher matcher = this.pattern.matcher(in.charSequence.subSequence(in.offset, in.charSequence.length()));
            if (matcher.lookingAt()) {
                in.offset += matcher.end();
                return matcher.toMatchResult();
            }
            throw Failure.exception;
        }
    }

    public static class SkipParser {
        private final Parser<?> parser;

        public SkipParser(Parser<?> parser) {
            this.parser = parser;
        }

        public SkipParser skip(Parser<?> that) {
            return new SkipParser(in -> {
                this.parser.parse(in);
                that.parse(in);
                return unit;
            });
        }

        public <U> Parser<U> then(Parser<U> that) {
            return in -> {
                this.parser.parse(in);
                return that.parse(in);
            };
        }

        public <B> Parser<B> then(Supplier<Parser<B>> that) {
            return in -> {
                this.parser.parse(in);
                return ((Parser)that.get()).parse(in);
            };
        }
    }

    @FunctionalInterface
    public static interface Function9<A, B, C, D, E, F, G, H, I, R> {
        public R apply(A var1, B var2, C var3, D var4, E var5, F var6, G var7, H var8, I var9);
    }

    @FunctionalInterface
    public static interface Function8<A, B, C, D, E, F, G, H, R> {
        public R apply(A var1, B var2, C var3, D var4, E var5, F var6, G var7, H var8);
    }

    @FunctionalInterface
    public static interface Function7<A, B, C, D, E, F, G, R> {
        public R apply(A var1, B var2, C var3, D var4, E var5, F var6, G var7);
    }

    @FunctionalInterface
    public static interface Function6<A, B, C, D, E, F, R> {
        public R apply(A var1, B var2, C var3, D var4, E var5, F var6);
    }

    @FunctionalInterface
    public static interface Function5<A, B, C, D, E, R> {
        public R apply(A var1, B var2, C var3, D var4, E var5);
    }

    @FunctionalInterface
    public static interface Function4<A, B, C, D, R> {
        public R apply(A var1, B var2, C var3, D var4);
    }

    @FunctionalInterface
    public static interface Function3<A, B, C, R> {
        public R apply(A var1, B var2, C var3);
    }

    public static class Pair<X, Y> {
        public final X first;
        public final Y second;

        public Pair(X first, Y second) {
            this.first = first;
            this.second = second;
        }

        public String toString() {
            return "(" + this.first + ", " + this.second + ")";
        }
    }

    public static class Input {
        CharSequence charSequence;
        int offset;

        public Input(CharSequence charSequence, int offset) {
            this.charSequence = charSequence;
            this.offset = offset;
        }
    }

    public static class Failure
    extends Exception {
        public static final Failure exception = new Failure();
    }
}

