package org.mule.datasense.catalog.builder;

import org.mule.datasense.catalog.model.resolver.ExampleTypeResolver;
import org.mule.datasense.catalog.model.resolver.ShapeTypeResolver;
import org.mule.datasense.catalog.model.resolver.SingleTypeResolver;
import org.mule.datasense.catalog.model.resolver.TypeResolver;

import java.net.URI;
import java.net.URISyntaxException;

public class TypesResolverBuilder {

  private final URI baseUri;

  private String name;
  private String location;
  private String shapeFormat;
  private String shapeLocation;
  private String shapeContent;
  private String exampleFormat;
  private String exampleLocation;
  private String exampleContent;
  private String format;
  private String shapeElement;
  private String exampleElement;

  public TypesResolverBuilder(URI baseUri) {
    this.baseUri = baseUri;
  }

  public void name(String name) {
    this.name = name;
  }

  public String getName() {
    return name;
  }

  public void format(String format) {
    this.format = format;
  }

  public void shapeFormat(String shapeFormat) {
    this.shapeFormat = shapeFormat;
  }

  public void shapeLocation(String shapeLocation) {
    this.shapeLocation = shapeLocation;
  }

  public void shapeContent(String shapeContent) {
    this.shapeContent = shapeContent;
  }

  public void shapeElement(String shapeElement) {
    this.shapeElement = shapeElement;
  }

  public void exampleFormat(String exampleFormat) {
    this.exampleFormat = exampleFormat;
  }

  public void exampleLocation(String exampleLocation) {
    this.exampleLocation = exampleLocation;
  }

  public void exampleElement(String exampleElement) {
    this.exampleElement = exampleElement;
  }

  public void exampleContent(String exampleContent) {
    this.exampleContent = exampleContent;
  }

  private URI resolveURI(String location) throws URISyntaxException {
    if (location == null) {
      return null;
    }
    URI locationURI = new URI(null, null, location, null, null);
    return baseUri != null ? baseUri.resolve(locationURI) : locationURI;
  }

  private String findTypeName(String name, String nativeName) {
    return nativeName != null ? nativeName : name;
  }

  public TypeResolver build() throws Exception {
    ShapeTypeResolver shapeTypeResolver = null;

    if (shapeFormat != null) {
      if (shapeLocation != null) {
        shapeTypeResolver = ShapeTypeResolver.createFromUrl(format, findTypeName(name, shapeElement), shapeFormat,
                                                            resolveURI(shapeLocation).toURL(), shapeElement);
      } else {
        shapeTypeResolver =
            ShapeTypeResolver.createFromContent(format, findTypeName(name, shapeElement), shapeFormat, shapeContent);
      }
    }
    ExampleTypeResolver exampleTypeResolver = null;

    if (exampleFormat != null) {
      if (exampleLocation != null) {
        URI exampleURI = resolveURI(exampleLocation);
        exampleTypeResolver =
            ExampleTypeResolver.createFromUrl(format, exampleElement, exampleFormat, exampleURI.toURL());
      } else {
        exampleTypeResolver =
            ExampleTypeResolver.createFromContent(format, exampleElement, exampleFormat, exampleContent);

      }
    }

    return new SingleTypeResolver(name, format, shapeTypeResolver, exampleTypeResolver);
  }
}
