package org.mule.datasense.catalog.loader;

import org.mule.datasense.catalog.builder.TypesCatalogBuilder;
import org.mule.datasense.catalog.builder.TypesCatalogBuilderContext;
import org.mule.datasense.catalog.model.TypesCatalog;

import java.io.File;
import java.net.URI;
import java.util.List;

public abstract class BaseTypesCatalogLoader implements TypesCatalogLoader {

  @Override
  public TypesCatalog loadFiles(List<File> files, TypesCatalogBuilderContext typesCatalogBuilderContext) throws Exception {
    TypesCatalogBuilder typesCatalogBuilder = new TypesCatalogBuilder(typesCatalogBuilderContext);
    TypesCatalogLoaderContext typesCatalogLoaderContext = new TypesCatalogLoaderContext(typesCatalogBuilder);
    loadFiles(files, typesCatalogLoaderContext);
    return typesCatalogBuilder.build();
  }

  @Override
  public TypesCatalog loadData(List<String> data, TypesCatalogBuilderContext typesCatalogBuilderContext, URI baseURI)
      throws Exception {
    TypesCatalogBuilder typesCatalogBuilder = new TypesCatalogBuilder(typesCatalogBuilderContext);
    typesCatalogBuilder.baseUri(baseURI);
    TypesCatalogLoaderContext typesCatalogLoaderContext = new TypesCatalogLoaderContext(typesCatalogBuilder);
    loadData(data, typesCatalogLoaderContext);
    return typesCatalogBuilder.build();
  }

  protected abstract void loadFiles(List<File> files, TypesCatalogLoaderContext typesCatalogLoaderContext);

  protected abstract void loadData(List<String> data, TypesCatalogLoaderContext typesCatalogLoaderContext);
}
