package org.mule.datasense.catalog.model;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import org.mule.datasense.catalog.model.resolver.TypeResolver;
import org.mule.datasense.catalog.model.resolver.TypeResolverException;
import org.mule.metadata.api.model.MetadataType;

import java.util.List;
import java.util.Optional;

public class TypesCatalog implements TypeResolver {

  private final List<TypeResolver> typeResolvers;

  public TypesCatalog(List<TypeResolver> typeResolvers) {
    Preconditions.checkNotNull(typeResolvers);
    this.typeResolvers = typeResolvers;
  }

  public Optional<MetadataType> resolveType(String typeIdentifier) throws TypeResolverException {
    try {
      return typeResolvers.stream()
          .map(typeResolver -> {
            try {
              return typeResolver.resolveType(typeIdentifier);
            } catch (TypeResolverException e) {
              Throwables.propagate(e);
              return null;
            }
          })
          .filter(Optional::isPresent)
          .map(Optional::get)
          .findFirst();
    } catch (Exception e) {
      final Throwable rootCause = Throwables.getRootCause(e);
      if (rootCause instanceof TypeResolverException) {
        throw (TypeResolverException) rootCause;
      } else {
        throw new TypeResolverException(rootCause);
      }
    }
  }
}
