package org.mule.datasense.catalog.model.resolver.loaders;

import com.google.common.collect.ImmutableList;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;

public class TypeLoaderRegistry {

  private static class TypeLoaderRegistryKey {

    private final String typeFormat;
    private final String loaderFormat;

    public TypeLoaderRegistryKey(String typeFormat, String loaderFormat) {
      this.typeFormat = typeFormat;
      this.loaderFormat = loaderFormat;
    }

    @Override
    public boolean equals(Object o) {
      if (this == o) {
        return true;
      }
      if (o == null || getClass() != o.getClass()) {
        return false;
      }

      TypeLoaderRegistryKey that = (TypeLoaderRegistryKey) o;

      if (!typeFormat.equals(that.typeFormat)) {
        return false;
      }
      return loaderFormat.equals(that.loaderFormat);

    }

    @Override
    public int hashCode() {
      int result = typeFormat.hashCode();
      result = 31 * result + loaderFormat.hashCode();
      return result;
    }
  }


  private final Map<TypeLoaderRegistryKey, TypeLoaderFactory> typeLoaderFactoryMap;

  public TypeLoaderRegistry(Class<? extends TypeLoaderFactory> serviceClass) {
    typeLoaderFactoryMap = new HashMap<>();
    ImmutableList.copyOf(ServiceLoader.load(serviceClass, Thread.currentThread().getContextClassLoader()).iterator()).forEach(
                                                                                                                              this::register);
  }

  public void register(TypeLoaderFactory typeLoaderFactory) {
    typeLoaderFactoryMap
        .put(new TypeLoaderRegistryKey(typeLoaderFactory.getTypeFormat(), typeLoaderFactory.getLoaderFormat()),
             typeLoaderFactory);
  }

  public Optional<TypeLoaderFactory> getFactory(String typeFormat, String shapeFormat) {
    return Optional.ofNullable(typeLoaderFactoryMap.get(new TypeLoaderRegistryKey(typeFormat, shapeFormat)));
  }
}
