/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.catalog.model.resolver;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.mule.datasense.catalog.model.resolver.TypeResolver;
import org.mule.datasense.catalog.model.resolver.loaders.CsvExampleTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.ExampleTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.ExcelExampleTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.JsonTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.TypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.TypeLoaderRegistry;
import org.mule.datasense.catalog.model.resolver.loaders.XmlTypeLoaderFactory;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;

public class ExampleTypeResolver
implements TypeResolver {
    private static TypeLoaderRegistry typeLoaderRegistry = new TypeLoaderRegistry(ExampleTypeLoaderFactory.class);
    private String typeIdentifier;
    private String format;
    private final TypeLoader typeLoader;

    private static TypeLoaderFactory getTypeLoaderFactory(String typeFormat, String shapeFormat) {
        TypeLoaderFactory typeLoaderFactory = typeLoaderRegistry.getFactory(typeFormat, shapeFormat).orElseThrow(() -> new RuntimeException(String.format("Unsupported typeFormat %s exampleFormat %s", typeFormat, shapeFormat)));
        return typeLoaderFactory;
    }

    ExampleTypeResolver(String typeIdentifier, String format, TypeLoader typeLoader) {
        Preconditions.checkNotNull((Object)typeLoader);
        Preconditions.checkNotNull((Object)format);
        this.typeLoader = typeLoader;
        this.format = format;
        this.typeIdentifier = typeIdentifier;
    }

    public static ExampleTypeResolver createFromUrl(String typeFormat, String typeIdentifier, String shapeFormat, URL schemaUrl) {
        return new ExampleTypeResolver(typeIdentifier, shapeFormat, ExampleTypeResolver.getTypeLoaderFactory(typeFormat, shapeFormat).createTypeLoader(FileUtils.toFile((URL)schemaUrl)));
    }

    public static ExampleTypeResolver createFromContent(String typeFormat, String typeIdentifier, String shapeFormat, String content) {
        return new ExampleTypeResolver(typeIdentifier, shapeFormat, ExampleTypeResolver.getTypeLoaderFactory(typeFormat, shapeFormat).createTypeLoader(content));
    }

    @Override
    public Optional<MetadataType> resolveType(String typeIdentifier) {
        return this.typeLoader.load(this.typeIdentifier, typeIdentifier);
    }

    static {
        typeLoaderRegistry.register(new JsonTypeLoaderFactory());
        typeLoaderRegistry.register(new XmlTypeLoaderFactory());
        typeLoaderRegistry.register(new CsvExampleTypeLoaderFactory());
        typeLoaderRegistry.register(new ExcelExampleTypeLoaderFactory());
    }
}

