/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.common.loader.xml;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlMatcher {
    private final Element element;

    public static Optional<XmlMatcher> match(Element element, QName qName) {
        Optional<XmlMatcher> result = Optional.empty();
        if (Objects.equals(element.getNamespaceURI(), qName.getNamespaceURI()) && Objects.equals(element.getLocalName(), qName.getLocalPart())) {
            result = Optional.of(new XmlMatcher(element));
        }
        return result;
    }

    private Stream<Node> nodeStream(NodeList nodeList) {
        return IntStream.range(0, nodeList.getLength()).mapToObj(nodeList::item);
    }

    private XmlMatcher(Element element) {
        Preconditions.checkNotNull((Object)element);
        this.element = element;
    }

    public Optional<XmlMatcher> match(QName qName) {
        if (qName == null) {
            return Optional.empty();
        }
        return this.matchMany(qName).findFirst();
    }

    public Stream<XmlMatcher> matchAll() {
        return this.nodeStream(this.element.getChildNodes()).filter(node -> node instanceof Element).map(node -> (Element)node).map(XmlMatcher::new);
    }

    public Optional<XmlMatcher> matchFirst() {
        return this.matchAll().findFirst();
    }

    public String value() {
        StringBuilder stringBuilder = new StringBuilder();
        this.nodeStream(this.element.getChildNodes()).filter(node -> node instanceof Text).map(node -> ((Text)node).getTextContent()).forEach(stringBuilder::append);
        return stringBuilder.toString();
    }

    public Stream<XmlMatcher> matchMany(QName qName) {
        return this.nodeStream(this.element.getElementsByTagNameNS(qName.getNamespaceURI(), qName.getLocalPart())).filter(node -> node instanceof Element).map(node -> (Element)node).filter(element -> qName.equals(new QName(element.getNamespaceURI(), element.getLocalName()))).map(XmlMatcher::new);
    }

    private Optional<Attr> matchAttributeNode(String namespaceUri, String localPart) {
        Attr attributeNodeNS = this.element.getAttributeNodeNS(namespaceUri, localPart);
        return Optional.ofNullable(attributeNodeNS);
    }

    private Optional<String> matchAttribute(String namespaceUri, String localPart) {
        Attr attributeNodeNS = this.matchAttributeNode(namespaceUri, localPart).orElse(null);
        return Optional.ofNullable(attributeNodeNS == null ? null : attributeNodeNS.getValue());
    }

    public Optional<String> matchAttribute(QName qName) {
        return this.matchAttribute(qName.getNamespaceURI(), qName.getLocalPart());
    }

    public Optional<String> matchAttribute(String localPart) {
        return this.matchAttribute(null, localPart);
    }

    public Optional<Attr> matchAttributeNode(String localPart) {
        return this.matchAttributeNode(null, localPart);
    }

    public String requireAttribute(QName qName) {
        return this.matchAttribute(qName).orElseThrow(IllegalArgumentException::new);
    }

    public String requireAttribute(String localPart) {
        return this.matchAttribute(localPart).orElseThrow(IllegalArgumentException::new);
    }

    public Element element() {
        return this.element;
    }

    public static Optional<QName> resolveQName(Attr attr) {
        String prefix;
        String uri;
        QName result = null;
        String value = attr.getTextContent();
        String[] split = value.split(":");
        if (split.length == 2 && (uri = attr.lookupNamespaceURI(prefix = split[0])) != null) {
            String localName = split[1];
            result = new QName(uri, localName);
        }
        return Optional.ofNullable(result);
    }
}

