/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.types.parser;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.datasense.types.parser.Parser;
import org.mule.datasense.types.parser.Parsers;

@RunWith(value=MockitoJUnitRunner.class)
public class ParserTest {
    private Parser<String> stringParser;

    @Before
    public void setUp() {
        this.stringParser = in -> in.toString().substring(in.offset, in.offset + 3);
    }

    @Test
    public void testParse() throws Parsers.Failure {
        Assert.assertEquals((Object)"org", (Object)this.stringParser.parse((CharSequence)"abcdef"));
    }

    @Test
    public void testParseWithCharSequence() throws Parsers.Failure {
        Assert.assertEquals((Object)"org", (Object)this.stringParser.parse((CharSequence)"abcdef"));
    }

    @Test
    public void testSkip() throws Parsers.Failure {
        Parser skipParser = this.stringParser.skip(this.stringParser);
        Assert.assertEquals((Object)"org", (Object)skipParser.parse((CharSequence)"abcde"));
    }

    @Test
    public void testSkipWithSupplier() throws Parsers.Failure {
        Parser skipParser = this.stringParser.skip(() -> this.stringParser);
        Assert.assertEquals((Object)"org", (Object)skipParser.parse((CharSequence)"abc4ef"));
    }

    @Test
    public void testOr() throws Parsers.Failure {
        Parser orParser = this.stringParser.or(() -> in -> "fallback");
        Assert.assertEquals((Object)"org", (Object)orParser.parse((CharSequence)"abcdef"));
    }

    @Test
    public void testOptional() throws Parsers.Failure {
        Parser optionalParser = this.stringParser.optional();
        Assert.assertEquals(Optional.of("org"), (Object)optionalParser.parse((CharSequence)"abcdef"));
    }

    @Test
    public void testFilter() throws Parsers.Failure {
        Parser filteredParser = this.stringParser.filter(s -> s.startsWith("a"));
        try {
            Assert.assertEquals((Object)"abc", (Object)filteredParser.parse((CharSequence)"abcdef"));
        }
        catch (Exception e) {
            Assert.assertNotNull((Object)e);
        }
    }

    @Test(expected=Parsers.Failure.class)
    public void testFilterFailure() throws Parsers.Failure {
        Parser filteredParser = this.stringParser.filter(s -> s.startsWith("b"));
        filteredParser.parse((CharSequence)"abcdef");
    }

    @Test
    public void testMap() throws Parsers.Failure {
        Parser mappedParser = this.stringParser.map(String::length);
        Assert.assertEquals((Object)3, (Object)mappedParser.parse((CharSequence)"abcdef"));
    }

    @Test
    public void testFlatMap() throws Parsers.Failure {
        Parser flatMappedParser = this.stringParser.flatMap(s -> in -> s.length());
        Assert.assertEquals((Object)3, (Object)flatMappedParser.parse((CharSequence)"abcdef"));
    }

    @Test
    public void testZeroOrMore_parsesMultiple() throws Parsers.Failure {
        Parser<Character> mockParser = new Parser<Character>(){
            int count = 0;

            public Character parse(Parsers.Input in) throws Parsers.Failure {
                if (this.count < 4) {
                    ++this.count;
                    return Character.valueOf('a');
                }
                throw Parsers.Failure.exception;
            }

            public Optional<Character> tryParse(Parsers.Input in) {
                int oldCount = this.count;
                try {
                    Character result = this.parse(in);
                    return Optional.of(result);
                }
                catch (Parsers.Failure e) {
                    this.count = oldCount;
                    return Optional.empty();
                }
            }
        };
        Parser parser = mockParser.zeroOrMore();
        List result = (List)parser.parse(new Parsers.Input((CharSequence)"", 0));
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertTrue((boolean)result.stream().allMatch(c -> c.charValue() == 'a'));
    }

    @Test
    public void testZeroOrMore_noneMatched() throws Parsers.Failure {
        Parser alwaysFailingParser = in -> {
            throw Parsers.Failure.exception;
        };
        Parser parser = alwaysFailingParser.zeroOrMore();
        List result = (List)parser.parse(new Parsers.Input((CharSequence)"", 0));
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testZeroOrMore_withNoMatch() throws Parsers.Failure {
        Parser parser = in -> {
            throw Parsers.Failure.exception;
        };
        Parser separator = in -> ",";
        List result = (List)parser.zeroOrMore(separator).parse(new Parsers.Input((CharSequence)"", 0));
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testZeroOrMore_withSeparator() throws Parsers.Failure {
        CountingParser parser = new CountingParser(3, "A");
        CountingParser separator = new CountingParser(2, ",");
        List result = (List)parser.zeroOrMore(separator).parse(new Parsers.Input((CharSequence)"", 0));
        Assert.assertNotEquals(Arrays.asList("A", "A", "A"), (Object)result);
    }

    @Test
    public void testZeroOrMore_noMatch() throws Parsers.Failure {
        Parser parser = in -> {
            throw Parsers.Failure.exception;
        };
        Parser separator = in -> ",";
        List result = (List)parser.zeroOrMore(separator).parse(new Parsers.Input((CharSequence)"", 0));
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testOneOrMore_withSeparator() throws Parsers.Failure {
        CountingParser parser = new CountingParser(3, "X");
        CountingParser separator = new CountingParser(2, ",");
        List result = (List)parser.oneOrMore(separator).parse(new Parsers.Input((CharSequence)"", 0));
        Assert.assertNotEquals(Arrays.asList("X", "X", "X"), (Object)result);
    }

    @Test(expected=Parsers.Failure.class)
    public void testOneOrMore_noMatch() throws Parsers.Failure {
        Parser parser = in -> {
            throw Parsers.Failure.exception;
        };
        Parser separator = in -> ",";
        parser.oneOrMore(separator).parse(new Parsers.Input((CharSequence)"", 0));
    }

    static class CountingParser
    implements Parser<String> {
        private int limit;
        private String value;
        private int count = 0;

        CountingParser(int limit, String value) {
            this.limit = limit;
            this.value = value;
        }

        public String parse(Parsers.Input in) throws Parsers.Failure {
            if (this.count < this.limit) {
                return this.value + this.count++;
            }
            throw Parsers.Failure.exception;
        }

        public Optional<String> tryParse(Parsers.Input in) {
            if (this.count < this.limit) {
                return Optional.of(this.value + this.count++);
            }
            return Optional.empty();
        }
    }
}

