/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.common.util;

import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mule.datasense.common.util.MutableHolder;

@RunWith(value=JUnit4.class)
public class MutableHolderTest {
    @Test
    public void testInitialValueIsEmpty() {
        MutableHolder holder = new MutableHolder();
        Optional value = holder.getValue();
        Assert.assertFalse((String)"Initial value should be empty", (boolean)value.isPresent());
    }

    @Test
    public void testSetAndGetValue() {
        MutableHolder holder = new MutableHolder();
        holder.setValue((Object)42);
        Optional value = holder.getValue();
        Assert.assertTrue((String)"Value should be present after setting", (boolean)value.isPresent());
        Assert.assertEquals((String)"Value should match what was set", (Object)42, value.get());
    }

    @Test
    public void testSetNullValue() {
        MutableHolder holder = new MutableHolder();
        holder.setValue((Object)42);
        holder.setValue(null);
        Optional value = holder.getValue();
        Assert.assertFalse((String)"Value should be empty after setting to null", (boolean)value.isPresent());
    }

    @Test
    public void testWithDifferentTypes() {
        MutableHolder stringHolder = new MutableHolder();
        stringHolder.setValue((Object)"test");
        Assert.assertEquals((Object)"test", stringHolder.getValue().get());
        MutableHolder booleanHolder = new MutableHolder();
        booleanHolder.setValue((Object)true);
        Assert.assertEquals((Object)Boolean.TRUE, booleanHolder.getValue().get());
    }
}

