/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.enrichment;

import com.google.gson.JsonElement;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.Collections;
import java.util.Optional;
import org.junit.Before;
import org.junit.Test;
import org.mule.datasense.catalog.builder.TypesCatalogBuilderContext;
import org.mule.datasense.catalog.loader.json.TypesCatalogJsonLoader;
import org.mule.datasense.catalog.model.TypesCatalog;
import org.mule.datasense.common.loader.json.JsonUtils;
import org.mule.datasense.common.util.Notifier;
import org.mule.datasense.declarations.loader.TypeDeclarationLoaderContext;
import org.mule.datasense.declarations.loader.json.ExtensionOperationTypeDeclarationJsonLoader;
import org.mule.datasense.declarations.loader.json.MessageProcessorTypeDeclarationJsonLoader;
import org.mule.datasense.enrichment.loader.ComponentModelEnrichmentLoaderContext;
import org.mule.datasense.enrichment.loader.json.ComponentModelEnrichmentJsonLoader;
import org.mule.datasense.enrichment.model.ComponentModelEnrichments;
import org.mule.datasense.util.ExpressionLanguageMetadataServiceUtils;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeDeclarationsJsonTest {
    private static final transient Logger logger = LoggerFactory.getLogger(TypeDeclarationsJsonTest.class);
    private static final File TESTS_FOLDER = new File("src/test/resources/datasense");

    @Before
    public void before() {
    }

    private Optional<ComponentModelEnrichments> loadComponentModelEnrichments(File appTypesFile) throws FileNotFoundException {
        JsonElement element = JsonUtils.parse((File)appTypesFile);
        ComponentModelEnrichmentJsonLoader componentModelEnrichmentJsonLoader = new ComponentModelEnrichmentJsonLoader();
        return componentModelEnrichmentJsonLoader.load(element, new ComponentModelEnrichmentLoaderContext());
    }

    @Test
    public void typesShouldBeResolvedFromCatalog() throws Exception {
        File testFolder = new File(TESTS_FOLDER, "test-002");
        File appTypesFile = new File(testFolder, "app-types.json");
        Notifier notifier = new Notifier(){

            public void reportWarning(I18nMessage i18nMessage) {
            }

            public void reportError(I18nMessage i18nMessage) {
            }

            public void reportFatalError(I18nMessage i18nMessage) {
            }
        };
        TypesCatalogBuilderContext typesCatalogBuilderContext = new TypesCatalogBuilderContext(notifier, ExpressionLanguageMetadataServiceUtils.createExpressionLanguageMetadataService());
        TypesCatalog typesCatalog = new TypesCatalogJsonLoader().loadFiles(Collections.singletonList(appTypesFile), typesCatalogBuilderContext);
        ExtensionOperationTypeDeclarationJsonLoader extensionOperationTypeDeclarationJsonLoader = new ExtensionOperationTypeDeclarationJsonLoader();
        MessageProcessorTypeDeclarationJsonLoader messageProcessorTypeDeclarationJsonLoader = new MessageProcessorTypeDeclarationJsonLoader();
        AstXmlParser astXmlParser = AstXmlParser.builder().build();
        try {
            this.loadComponentModelEnrichments(appTypesFile).ifPresent(componentModelEnrichments -> {
                File appFile = new File(testFolder, "app.xml");
                ArtifactAst applicationModel = astXmlParser.parse(new URI[]{appFile.toURI()});
                applicationModel.recursiveStream().forEach(componentModel -> componentModelEnrichments.enrich(componentModel).forEach(enrichment -> {
                    JsonElement element = (JsonElement)enrichment;
                    TypeDeclarationLoaderContext typeDeclarationLoaderContext = new TypeDeclarationLoaderContext(componentModel, typesCatalog, notifier);
                    extensionOperationTypeDeclarationJsonLoader.load(element, typeDeclarationLoaderContext).ifPresent(extensionOperationTypeDeclaration -> {});
                    messageProcessorTypeDeclarationJsonLoader.load(element, typeDeclarationLoaderContext).ifPresent(messageProcessorTypeDeclaration -> {});
                }));
            });
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

