package org.mule.datasense.enrichment.model;

public class ComponentModelSelectors {

  public static ComponentModelSelector create(String selector) {
    if (selector.startsWith(IdComponentModelSelector.PREFIX)) {
      return new IdComponentModelSelector(selector.substring(1));
    } else if (selector.startsWith(PathComponentModelSelector.PREFIX)) {
      return new PathComponentModelSelector(selector.substring(1));
    } else {
      throw new IllegalArgumentException(String.format("Invalid selector '%s'", selector));
    }
  }

}
