/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.common.loader.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import org.mule.datasense.common.loader.json.JsonArrayStrategy;
import org.mule.datasense.common.loader.json.JsonMatcher;
import org.mule.datasense.common.loader.json.JsonMatcherException;
import org.mule.datasense.common.loader.json.JsonMatcherStrategy;
import org.mule.datasense.common.loader.json.JsonObjectStrategy;

public class JsonMatcherTest {
    @Test
    public void testJsonArrayStream() {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add((Number)1);
        jsonArray.add("test");
        jsonArray.add(Boolean.valueOf(true));
        Stream stream = JsonMatcher.jsonArrayStream((JsonArray)jsonArray);
        Object[] elements = stream.toArray();
        Assert.assertEquals((long)3L, (long)elements.length);
        Assert.assertTrue((boolean)(elements[0] instanceof JsonPrimitive));
        Assert.assertEquals((long)1L, (long)((JsonPrimitive)elements[0]).getAsInt());
        Assert.assertTrue((boolean)(elements[1] instanceof JsonPrimitive));
        Assert.assertEquals((Object)"test", (Object)((JsonPrimitive)elements[1]).getAsString());
        Assert.assertTrue((boolean)(elements[2] instanceof JsonPrimitive));
        Assert.assertTrue((boolean)((JsonPrimitive)elements[2]).getAsBoolean());
    }

    @Test
    public void testCreateMatcher() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", "John");
        Optional matcher = JsonMatcher.createMatcher((JsonElement)jsonObject);
        Assert.assertTrue((boolean)matcher.isPresent());
        Optional emptyMatcher = JsonMatcher.createMatcher(null);
        Assert.assertFalse((boolean)emptyMatcher.isPresent());
    }

    @Test
    public void testMatch() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", "John");
        Optional nonExistentMatcher = JsonMatcher.match((JsonElement)jsonObject, (String)"age");
        Assert.assertFalse((boolean)nonExistentMatcher.isPresent());
    }

    @Test
    public void testCreateRequiredMatcher() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", "John");
        JsonMatcher matcher = JsonMatcher.createRequiredMatcher((JsonElement)jsonObject);
        Assert.assertNotNull((Object)matcher);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateRequiredMatcherWithNull() {
        JsonMatcher.createRequiredMatcher(null);
    }

    @Test
    public void testCreateStrategy() {
        JsonObject jsonObject = new JsonObject();
        JsonMatcherStrategy objectStrategy = JsonMatcher.createStrategy((JsonElement)jsonObject);
        Assert.assertTrue((boolean)(objectStrategy instanceof JsonObjectStrategy));
        JsonArray jsonArray = new JsonArray();
        JsonMatcherStrategy arrayStrategy = JsonMatcher.createStrategy((JsonElement)jsonArray);
        Assert.assertTrue((boolean)(arrayStrategy instanceof JsonArrayStrategy));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateStrategyWithInvalidType() {
        JsonPrimitive jsonPrimitive = new JsonPrimitive("test");
        JsonMatcher.createStrategy((JsonElement)jsonPrimitive);
    }

    @Test
    public void testRequire() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", "John");
        JsonMatcher matcher = JsonMatcher.createRequiredMatcher((JsonElement)jsonObject);
        Assert.assertNotNull((Object)matcher);
    }

    @Test(expected=JsonMatcherException.class)
    public void testRequireNonExistentField() {
        JsonObject jsonObject = new JsonObject();
        JsonMatcher matcher = JsonMatcher.createRequiredMatcher((JsonElement)jsonObject);
        matcher.require("nonexistent");
    }

    @Test
    public void testMatchMany() {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add((JsonElement)new JsonPrimitive("item1"));
        jsonArray.add((JsonElement)new JsonPrimitive("item2"));
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("items", (JsonElement)jsonArray);
        JsonMatcher matcher = JsonMatcher.createRequiredMatcher((JsonElement)jsonObject);
        Optional matchMany = matcher.matchMany("items");
        Assert.assertTrue((boolean)matchMany.isPresent());
        Assert.assertEquals((long)2L, (long)((Stream)matchMany.get()).count());
    }

    @Test
    public void testRequireMany() {
        JsonArray jsonArray = new JsonArray();
        jsonArray.add((JsonElement)new JsonPrimitive("item1"));
        jsonArray.add((JsonElement)new JsonPrimitive("item2"));
        JsonObject jsonObject = new JsonObject();
        jsonObject.add("items", (JsonElement)jsonArray);
        JsonMatcher matcher = JsonMatcher.createRequiredMatcher((JsonElement)jsonObject);
        Stream requiredMany = matcher.requireMany("items");
        Assert.assertNotNull((Object)requiredMany);
        Assert.assertEquals((long)2L, (long)requiredMany.count());
    }

    @Test(expected=JsonMatcherException.class)
    public void testRequireManyNonExistentField() {
        JsonObject jsonObject = new JsonObject();
        JsonMatcher matcher = JsonMatcher.createRequiredMatcher((JsonElement)jsonObject);
        matcher.requireMany("nonexistent");
    }

    @Test
    public void testMatchAttribute() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", "John");
        JsonMatcher matcher = JsonMatcher.createRequiredMatcher((JsonElement)jsonObject);
        Optional attribute = matcher.matchAttribute("name");
        Assert.assertTrue((boolean)attribute.isPresent());
        Assert.assertEquals((Object)"John", (Object)((JsonPrimitive)attribute.get()).getAsString());
    }

    @Test
    public void testMatchString() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", "John");
        JsonMatcher matcher = JsonMatcher.createRequiredMatcher((JsonElement)jsonObject);
        Optional stringValue = matcher.matchString("name");
        Assert.assertTrue((boolean)stringValue.isPresent());
        Assert.assertEquals((Object)"John", stringValue.get());
    }

    @Test
    public void testRequireAttribute() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", "John");
        JsonMatcher matcher = JsonMatcher.createRequiredMatcher((JsonElement)jsonObject);
        JsonPrimitive attribute = matcher.requireAttribute("name");
        Assert.assertNotNull((Object)attribute);
        Assert.assertEquals((Object)"John", (Object)attribute.getAsString());
    }

    @Test(expected=JsonMatcherException.class)
    public void testRequireAttributeNonExistentField() {
        JsonObject jsonObject = new JsonObject();
        JsonMatcher matcher = JsonMatcher.createRequiredMatcher((JsonElement)jsonObject);
        matcher.requireAttribute("nonexistent");
    }

    @Test
    public void testRequireString() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", "John");
        JsonMatcher matcher = JsonMatcher.createRequiredMatcher((JsonElement)jsonObject);
        String stringValue = matcher.requireString("name");
        Assert.assertEquals((Object)"John", (Object)stringValue);
    }

    @Test
    public void testElement() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", "John");
        JsonMatcher matcher = JsonMatcher.createRequiredMatcher((JsonElement)jsonObject);
        JsonElement element = matcher.element();
        Assert.assertTrue((boolean)element.isJsonObject());
        Assert.assertEquals((Object)"John", (Object)element.getAsJsonObject().get("name").getAsString());
    }
}

