/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.catalog.model;

import com.google.common.base.Throwables;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import org.mule.datasense.catalog.model.TypesCatalog;
import org.mule.datasense.catalog.model.resolver.TypeResolver;
import org.mule.datasense.catalog.model.resolver.TypeResolverException;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.impl.DefaultStringType;

public class TypesCatalogTest {
    @Test
    public void testEmptyResolverList() throws TypeResolverException {
        TypesCatalog catalog = new TypesCatalog(Collections.emptyList());
        Optional result = catalog.resolveType("string");
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test
    public void testResolveTypeFound() throws TypeResolverException {
        DefaultStringType stringType = new DefaultStringType(MetadataFormat.JAVA, new HashMap());
        TypeResolver testResolver = arg_0 -> TypesCatalogTest.lambda$testResolveTypeFound$0((MetadataType)stringType, arg_0);
        TypesCatalog catalog = new TypesCatalog(Collections.singletonList(testResolver));
        Optional result = catalog.resolveType("string");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)stringType, result.get());
    }

    @Test
    public void testResolveTypeNotFound() throws TypeResolverException {
        TypeResolver testResolver = typeId -> Optional.empty();
        TypesCatalog catalog = new TypesCatalog(Collections.singletonList(testResolver));
        Optional result = catalog.resolveType("unknown");
        Assert.assertFalse((boolean)result.isPresent());
    }

    @Test(expected=TypeResolverException.class)
    public void testResolveTypeWithExceptionInLambda() throws TypeResolverException {
        TypeResolver exceptionThrowingResolver = new TypeResolver(){

            public Optional<MetadataType> resolveType(String typeIdentifier) throws TypeResolverException {
                throw new TypeResolverException("Exception in lambda");
            }
        };
        TypesCatalog catalog = new TypesCatalog(Collections.singletonList(exceptionThrowingResolver));
        catalog.resolveType("any");
    }

    @Test(expected=TypeResolverException.class)
    public void testThrowablesPropagateLineInLambda() throws TypeResolverException {
        final AtomicBoolean lambdaExecuted = new AtomicBoolean(false);
        TypeResolver exceptionThrowingResolver = new TypeResolver(){

            public Optional<MetadataType> resolveType(String typeIdentifier) throws TypeResolverException {
                lambdaExecuted.set(true);
                throw new TypeResolverException("Test propagate in lambda");
            }
        };
        TypesCatalog catalog = new TypesCatalog(Collections.singletonList(exceptionThrowingResolver));
        try {
            catalog.resolveType("any");
        }
        catch (TypeResolverException e) {
            Assert.assertTrue((String)"Lambda with Throwables.propagate should have been executed", (boolean)lambdaExecuted.get());
            throw e;
        }
    }

    @Test(expected=TypeResolverException.class)
    public void testNonTypeResolverExceptionWrapping() throws TypeResolverException {
        TypeResolver exceptionThrowingResolver = typeIdentifier -> {
            throw new NullPointerException("This is not a TypeResolverException");
        };
        TypesCatalog catalog = new TypesCatalog(Collections.singletonList(exceptionThrowingResolver));
        catalog.resolveType("any");
    }

    @Test(expected=TypeResolverException.class)
    public void testNestedExceptionsWrapping() throws TypeResolverException {
        RuntimeException innerException = new RuntimeException("Inner runtime exception");
        Exception outerException = new Exception("Outer exception", innerException);
        TypeResolver exceptionThrowingResolver = typeIdentifier -> {
            try {
                throw outerException;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
        TypesCatalog catalog = new TypesCatalog(Collections.singletonList(exceptionThrowingResolver));
        catalog.resolveType("any");
    }

    @Test
    public void testMultipleResolvers() throws TypeResolverException {
        DefaultStringType stringType = new DefaultStringType(MetadataFormat.JAVA, new HashMap());
        TypeResolver firstResolver = typeId -> Optional.empty();
        TypeResolver secondResolver = arg_0 -> TypesCatalogTest.lambda$testMultipleResolvers$5((MetadataType)stringType, arg_0);
        TypesCatalog catalog = new TypesCatalog(Arrays.asList(firstResolver, secondResolver));
        Optional result = catalog.resolveType("string");
        Assert.assertTrue((boolean)result.isPresent());
        Assert.assertEquals((Object)stringType, result.get());
    }

    @Test
    public void testPropagateExceptionWithMultipleResolvers() throws TypeResolverException {
        final AtomicInteger throwingResolverCalled = new AtomicInteger(0);
        final AtomicInteger workingResolverCalled = new AtomicInteger(0);
        TypeResolver throwingResolver = new TypeResolver(){

            public Optional<MetadataType> resolveType(String typeIdentifier) throws TypeResolverException {
                throwingResolverCalled.incrementAndGet();
                throw new TypeResolverException("This exception should be propagated");
            }
        };
        DefaultStringType stringType = new DefaultStringType(MetadataFormat.JAVA, new HashMap());
        TypeResolver workingResolver = new TypeResolver(){
            final /* synthetic */ MetadataType val$stringType;
            {
                this.val$stringType = metadataType;
            }

            public Optional<MetadataType> resolveType(String typeIdentifier) throws TypeResolverException {
                workingResolverCalled.incrementAndGet();
                return Optional.of(this.val$stringType);
            }
        };
        TypesCatalog catalog = new TypesCatalog(Arrays.asList(throwingResolver, workingResolver));
        try {
            catalog.resolveType("any");
        }
        catch (TypeResolverException e) {
            Assert.assertEquals((String)"First resolver should have been called exactly once", (long)1L, (long)throwingResolverCalled.get());
            Assert.assertEquals((String)"Second resolver should not have been called", (long)0L, (long)workingResolverCalled.get());
            Assert.assertEquals((Object)"This exception should be propagated", (Object)e.getMessage());
        }
    }

    @Test
    public void testDirectThrowablesPropagateCall() throws TypeResolverException {
        final AtomicInteger firstResolverCalled = new AtomicInteger(0);
        final AtomicInteger secondResolverCalled = new AtomicInteger(0);
        TypeResolver throwingResolver = new TypeResolver(){

            public Optional<MetadataType> resolveType(String typeIdentifier) throws TypeResolverException {
                firstResolverCalled.incrementAndGet();
                throw new TypeResolverException("Special propagated exception");
            }
        };
        TypeResolver secondResolver = new TypeResolver(){

            public Optional<MetadataType> resolveType(String typeIdentifier) throws TypeResolverException {
                secondResolverCalled.incrementAndGet();
                return Optional.empty();
            }
        };
        TypesCatalog catalog = new TypesCatalog(Arrays.asList(throwingResolver, secondResolver));
        try {
            catalog.resolveType("any");
            Assert.fail((String)"Expected TypeResolverException to be thrown");
        }
        catch (TypeResolverException e) {
            Assert.assertEquals((String)"First resolver should be called exactly once", (long)1L, (long)firstResolverCalled.get());
            Assert.assertEquals((String)"Second resolver should not be called", (long)0L, (long)secondResolverCalled.get());
            Assert.assertEquals((Object)"Special propagated exception", (Object)e.getMessage());
        }
    }

    @Test
    public void testCaughtPropagatedThrowable() {
        TypeResolver throwingResolver = new TypeResolver(){

            public Optional<MetadataType> resolveType(String typeIdentifier) throws TypeResolverException {
                throw new TypeResolverException("Exception for propagation test");
            }
        };
        TypesCatalog catalog = new TypesCatalog(Collections.singletonList(throwingResolver));
        try {
            Optional result = catalog.resolveType("any");
            Assert.fail((String)"Expected TypeResolverException to be thrown");
        }
        catch (TypeResolverException e) {
            Assert.assertEquals((Object)"Exception for propagation test", (Object)e.getMessage());
        }
    }

    @Test
    public void testThrowablesPropagateDirectly() {
        try {
            Function<TypeResolver, Optional> mapFunction = typeResolver -> {
                try {
                    throw new TypeResolverException("Test exception for propagation");
                }
                catch (TypeResolverException e) {
                    Throwables.propagate((Throwable)e);
                    return null;
                }
            };
            TypeResolver resolver = typeIdentifier -> Optional.empty();
            mapFunction.apply(resolver);
            Assert.fail((String)"Expected an exception to be thrown by Throwables.propagate");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((String)"Expected cause to be a TypeResolverException", (boolean)(e.getCause() instanceof TypeResolverException));
            Assert.assertEquals((Object)"Test exception for propagation", (Object)e.getCause().getMessage());
        }
    }

    private static /* synthetic */ Optional lambda$testMultipleResolvers$5(MetadataType stringType, String typeId) throws TypeResolverException {
        return Optional.of(stringType);
    }

    private static /* synthetic */ Optional lambda$testResolveTypeFound$0(MetadataType stringType, String typeId) throws TypeResolverException {
        return Optional.of(stringType);
    }
}

