/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.common.util;

import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mule.datasense.common.util.TypeUtils;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;

@RunWith(value=JUnit4.class)
public class TypeUtilsTest {
    @Test
    public void testGetTypeBuilderWithJavaFormat() {
        BaseTypeBuilder typeBuilder = TypeUtils.getTypeBuilder((MetadataFormat)MetadataFormat.JAVA);
        Assert.assertNotNull((String)"TypeBuilder should not be null", (Object)typeBuilder);
        Assert.assertNotNull((Object)typeBuilder.stringType().build());
    }

    @Test
    public void testGetTypeBuilderWithJsonFormat() {
        BaseTypeBuilder typeBuilder = TypeUtils.getTypeBuilder((MetadataFormat)MetadataFormat.JSON);
        Assert.assertNotNull((String)"TypeBuilder should not be null", (Object)typeBuilder);
        Assert.assertNotNull((Object)typeBuilder.numberType().build());
    }

    @Test
    public void testGetTypeBuilderWithXmlFormat() {
        BaseTypeBuilder typeBuilder = TypeUtils.getTypeBuilder((MetadataFormat)MetadataFormat.XML);
        Assert.assertNotNull((String)"TypeBuilder should not be null", (Object)typeBuilder);
        Assert.assertNotNull((Object)typeBuilder.booleanType().build());
    }

    @Test
    public void testGetTypeBuilderNoArgMethod() {
        try {
            Method method = TypeUtils.class.getDeclaredMethod("getTypeBuilder", new Class[0]);
            if (method != null) {
                method.setAccessible(true);
                BaseTypeBuilder typeBuilder = (BaseTypeBuilder)method.invoke(null, new Object[0]);
                Assert.assertNotNull((String)"TypeBuilder from no-arg method should not be null", (Object)typeBuilder);
            }
        }
        catch (NoSuchMethodException method) {
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error testing no-arg method", e);
        }
    }
}

