/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.common.loader.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.datasense.common.loader.json.JsonArrayStrategy;

public class JsonArrayStrategyTest {
    private JsonArrayStrategy jsonArrayStrategy;
    private JsonArray jsonArray;

    @Before
    public void setUp() {
        this.jsonArray = new JsonArray();
        this.jsonArray.add((JsonElement)new JsonPrimitive("value1"));
        this.jsonArray.add((JsonElement)new JsonPrimitive((Number)42));
        this.jsonArray.add((JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        this.jsonArrayStrategy = new JsonArrayStrategy(this.jsonArray);
    }

    @Test
    public void testMatch() {
        try {
            this.jsonArrayStrategy.match("anyName");
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testMatchMany() {
        try {
            this.jsonArrayStrategy.matchMany("anyName");
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testMatchManyWithoutArgument() {
        Optional result = this.jsonArrayStrategy.matchMany();
        Assert.assertTrue((boolean)result.isPresent());
        Stream matcherStream = (Stream)result.get();
        Assert.assertNotNull((Object)matcherStream);
    }

    @Test
    public void testMatchAttribute() {
        try {
            this.jsonArrayStrategy.matchAttribute("anyName");
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testElement() {
        JsonElement element = this.jsonArrayStrategy.element();
        Assert.assertNotNull((Object)element);
        Assert.assertTrue((boolean)element.isJsonArray());
        Assert.assertEquals((Object)this.jsonArray, (Object)element);
    }

    @Test
    public void testConstructor() {
        JsonArray emptyArray = new JsonArray();
        JsonArrayStrategy strategy = new JsonArrayStrategy(emptyArray);
        Assert.assertEquals((Object)emptyArray, (Object)strategy.element());
    }
}

