/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.types.parser;

import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import org.mule.datasense.types.parser.Parser;
import org.mule.datasense.types.parser.Parsers;

public class ParsersTest {
    @Test
    public void testEmpty() throws Parsers.Failure {
        Parser emptyParser = Parsers.empty();
        Object result = emptyParser.parse(new Parsers.Input((CharSequence)"", 0));
        Assert.assertEquals((Object)Parsers.unit, (Object)result);
    }

    @Test
    public void testSuccess() throws Parsers.Failure {
        Parser successParser = Parsers.success((Object)"test");
        String result = (String)successParser.parse(new Parsers.Input((CharSequence)"", 0));
        Assert.assertEquals((Object)"test", (Object)result);
    }

    @Test(expected=Parsers.Failure.class)
    public void testFailure() throws Parsers.Failure {
        Parser failureParser = Parsers.failure((String)"Test failure");
        failureParser.parse(new Parsers.Input((CharSequence)"", 0));
    }

    @Test
    public void testChoice() throws Parsers.Failure {
        Parser parser1 = Parsers.string((String)"hello");
        Parser parser2 = Parsers.string((String)"world");
        Parser choiceParser = Parsers.choice((Parser)parser1, (Parser[])new Parser[]{parser2});
        Assert.assertEquals((Object)"hello", (Object)choiceParser.parse(new Parsers.Input((CharSequence)"hello", 0)));
        Assert.assertEquals((Object)"world", (Object)choiceParser.parse(new Parsers.Input((CharSequence)"world", 0)));
    }

    @Test
    public void testSkip() throws Parsers.Failure {
        Parser stringParser = Parsers.string((String)"test");
        Parsers.SkipParser skipParser = Parsers.skip((Parser)stringParser);
        Parser thenParser = skipParser.then(Parsers.string((String)"next"));
        String result = (String)thenParser.parse(new Parsers.Input((CharSequence)"testnext", 0));
        Assert.assertEquals((Object)"next", (Object)result);
    }

    @Test
    public void testThen() throws Parsers.Failure {
        Parser thenParser = Parsers.then(() -> Parsers.string((String)"test"));
        String result = (String)thenParser.parse(new Parsers.Input((CharSequence)"test", 0));
        Assert.assertEquals((Object)"test", (Object)result);
    }

    @Test
    public void testBegin() throws Parsers.Failure {
        Parser beginParser = Parsers.begin();
        Object result = beginParser.parse(new Parsers.Input((CharSequence)"test", 0));
        Assert.assertEquals((Object)Parsers.unit, (Object)result);
    }

    @Test
    public void testEnd() throws Parsers.Failure {
        Parser endParser = Parsers.end();
        Object result = endParser.parse(new Parsers.Input((CharSequence)"test", 4));
        Assert.assertEquals((Object)Parsers.unit, (Object)result);
    }

    @Test(expected=Parsers.Failure.class)
    public void testEndFailure() throws Parsers.Failure {
        Parser endParser = Parsers.end();
        endParser.parse(new Parsers.Input((CharSequence)"test", 0));
    }

    @Test
    public void testString() throws Parsers.Failure {
        Parser stringParser = Parsers.string((String)"test");
        String result = (String)stringParser.parse(new Parsers.Input((CharSequence)"test", 0));
        Assert.assertEquals((Object)"test", (Object)result);
    }

    @Test
    public void testRegexString() throws Parsers.Failure {
        Parser regexParser = Parsers.regex((String)"\\d+");
        MatchResult result = (MatchResult)regexParser.parse(new Parsers.Input((CharSequence)"123abc", 0));
        Assert.assertEquals((Object)"123", (Object)result.group());
    }

    @Test
    public void testRegexPattern() throws Parsers.Failure {
        Pattern pattern = Pattern.compile("\\d+");
        Parser regexParser = Parsers.regex((Pattern)pattern);
        MatchResult result = (MatchResult)regexParser.parse(new Parsers.Input((CharSequence)"123abc", 0));
        Assert.assertEquals((Object)"123", (Object)result.group());
    }

    @Test
    public void testMatch() throws Parsers.Failure {
        Parser parser = Parsers.string((String)"A").then(Parsers.string((String)"B")).then(Parsers.string((String)"C"));
        Parser matchedParser = parser.map(Parsers.match((a, b, c) -> a + b + c));
        String result = (String)matchedParser.parse(new Parsers.Input((CharSequence)"ABC", 0));
        Assert.assertEquals((Object)"ABC", (Object)result);
    }

    @Test
    public void testPair() {
        Parsers.Pair pair = new Parsers.Pair((Object)"test", (Object)42);
        Assert.assertEquals((Object)"test", (Object)pair.first);
        Assert.assertEquals((Object)42, (Object)pair.second);
        Assert.assertEquals((Object)"(test, 42)", (Object)pair.toString());
    }

    @Test
    public void testGenericMethods() {
        Assert.assertNotNull((Object)Parsers.empty());
        Assert.assertNotNull((Object)Parsers.success((Object)"test"));
        Assert.assertNotNull((Object)Parsers.failure((String)"test"));
        Assert.assertNotNull((Object)Parsers.string((String)"test"));
        Assert.assertNotNull((Object)Parsers.choice((Parser)Parsers.string((String)"test"), (Parser[])new Parser[0]));
        Assert.assertNotNull((String)"hello", (Object)Parsers.string((String)"test").then(in -> "hello"));
        Assert.assertNotNull((Object)new Parsers.Pair((Object)"test", (Object)"test").toString());
        Assert.assertNotNull(Parsers.match(a -> a).apply("a"));
        Assert.assertNotNull(Parsers.match((a, b) -> a).apply(new Parsers.Pair((Object)"a", (Object)"b")));
        Assert.assertNotNull(Parsers.match((a, b, c) -> a).apply(new Parsers.Pair((Object)new Parsers.Pair((Object)"a", (Object)"b"), (Object)"c")));
        Assert.assertNotNull(Parsers.match((a, b, c, d) -> a).apply(new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)"a", (Object)"d"), (Object)"b"), (Object)"c")));
        Assert.assertNotNull(Parsers.match((a, b, c, d, e) -> a).apply(new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)"a", (Object)"e"), (Object)"d"), (Object)"b"), (Object)"c")));
        Assert.assertNotNull(Parsers.match((a, b, c, d, e, f) -> a).apply(new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)"a", (Object)"f"), (Object)"e"), (Object)"d"), (Object)"b"), (Object)"c")));
        Assert.assertNotNull(Parsers.match((a, b, c, d, e, f, g) -> a).apply(new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)"a", (Object)"a"), (Object)"f"), (Object)"e"), (Object)"d"), (Object)"b"), (Object)"c")));
        Assert.assertNotNull(Parsers.match((a, b, c, d, e, f, g, h) -> a).apply(new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)"a", (Object)"a"), (Object)"a"), (Object)"f"), (Object)"e"), (Object)"d"), (Object)"b"), (Object)"c")));
        Assert.assertNotNull(Parsers.match((a, b, c, d, e, f, g, h, i) -> a).apply(new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)new Parsers.Pair((Object)"a", (Object)"z"), (Object)"a"), (Object)"a"), (Object)"f"), (Object)"e"), (Object)"d"), (Object)"b"), (Object)"c")));
    }
}

