/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.catalog.builder;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.mule.datasense.catalog.builder.TypesCatalogBuilderContext;
import org.mule.datasense.catalog.model.resolver.ExampleTypeResolver;
import org.mule.datasense.catalog.model.resolver.ShapeTypeResolver;
import org.mule.datasense.catalog.model.resolver.SingleTypeResolver;
import org.mule.datasense.catalog.model.resolver.TypeResolver;
import org.mule.datasense.catalog.model.resolver.loaders.TypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.TypeLoaderRegistry;
import org.mule.metadata.api.TypeLoader;

public class TypesResolverBuilder {
    private final URI baseUri;
    private String name;
    private String location;
    private String shapeFormat;
    private String shapeLocation;
    private String shapeContent;
    private String exampleFormat;
    private String exampleLocation;
    private String exampleContent;
    private String format;
    private String shapeElement;
    private String exampleElement;

    public TypesResolverBuilder(URI baseUri) {
        this.baseUri = baseUri;
    }

    public void name(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void format(String format) {
        this.format = format;
    }

    public void shapeFormat(String shapeFormat) {
        this.shapeFormat = shapeFormat;
    }

    public void shapeLocation(String shapeLocation) {
        this.shapeLocation = shapeLocation;
    }

    public void shapeContent(String shapeContent) {
        this.shapeContent = shapeContent;
    }

    public void shapeElement(String shapeElement) {
        this.shapeElement = shapeElement;
    }

    public void exampleFormat(String exampleFormat) {
        this.exampleFormat = exampleFormat;
    }

    public void exampleLocation(String exampleLocation) {
        this.exampleLocation = exampleLocation;
    }

    public void exampleElement(String exampleElement) {
        this.exampleElement = exampleElement;
    }

    public void exampleContent(String exampleContent) {
        this.exampleContent = exampleContent;
    }

    private static URI resolveURI(String location, URI baseUri) throws URISyntaxException {
        if (location == null) {
            return null;
        }
        URI locationURI = new URI(null, null, location, null, null);
        return baseUri != null ? baseUri.resolve(locationURI) : locationURI;
    }

    private String findTypeName(String name, String nativeName) {
        return nativeName != null ? nativeName : name;
    }

    private static TypeLoaderFactory getTypeLoaderFactory(String typeFormat, String shapeFormat, TypeLoaderRegistry typeLoaderRegistry) {
        TypeLoaderFactory typeLoaderFactory = typeLoaderRegistry.getFactory(typeFormat, shapeFormat).orElseThrow(() -> new RuntimeException(String.format("Unsupported typeFormat %s %s Format %s", typeFormat, typeLoaderRegistry.getName(), shapeFormat)));
        return typeLoaderFactory;
    }

    private static TypeLoader createTypeLoader(String location, String content, TypeLoaderFactory typeLoaderFactory, URI baseUri) throws URISyntaxException, MalformedURLException {
        return location != null ? typeLoaderFactory.createTypeLoader(FileUtils.toFile((URL)TypesResolverBuilder.resolveURI(location, baseUri).toURL())) : typeLoaderFactory.createTypeLoader(content);
    }

    public TypeResolver build(TypesCatalogBuilderContext typesCatalogBuilderContext) throws Exception {
        ShapeTypeResolver shapeTypeResolver = null;
        if (this.shapeFormat != null) {
            TypeLoaderFactory typeLoaderFactory = TypesResolverBuilder.getTypeLoaderFactory(this.format, this.shapeFormat, typesCatalogBuilderContext.getShapeTypeLoaderRegistry());
            TypeLoader typeLoader = TypesResolverBuilder.createTypeLoader(this.shapeLocation, this.shapeContent, typeLoaderFactory, this.baseUri);
            shapeTypeResolver = new ShapeTypeResolver(this.findTypeName(this.name, this.shapeElement), this.shapeFormat, typeLoader);
        }
        ExampleTypeResolver exampleTypeResolver = null;
        if (this.exampleFormat != null) {
            TypeLoaderFactory typeLoaderFactory = TypesResolverBuilder.getTypeLoaderFactory(this.format, this.exampleFormat, typesCatalogBuilderContext.getExampleTypeLoaderRegistry());
            TypeLoader typeLoader = TypesResolverBuilder.createTypeLoader(this.exampleLocation, this.exampleContent, typeLoaderFactory, this.baseUri);
            exampleTypeResolver = new ExampleTypeResolver(this.exampleElement, this.exampleFormat, typeLoader);
        }
        return new SingleTypeResolver(this.name, this.format, shapeTypeResolver, exampleTypeResolver);
    }
}

