/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.catalog.loader.test;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.text.IsEqualIgnoringWhiteSpace;
import org.junit.Assert;
import org.junit.Test;
import org.mule.datasense.catalog.builder.TypesCatalogBuilderContext;
import org.mule.datasense.catalog.loader.json.TypesCatalogJsonLoader;
import org.mule.datasense.catalog.loader.xml.TypesCatalogXmlLoader;
import org.mule.datasense.catalog.model.TypesCatalog;
import org.mule.datasense.common.util.Notifier;
import org.mule.datasense.util.ExpressionLanguageMetadataServiceUtils;
import org.mule.metadata.api.annotation.MetadataFormatPropertiesAnnotation;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.internal.utils.MetadataTypeWriter;
import org.mule.runtime.api.i18n.I18nMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypesCatalogLoaderTest {
    private static final transient Logger logger = LoggerFactory.getLogger(TypesCatalogLoaderTest.class);
    private static final File TESTS_FOLDER = new File("src/test/resources/datasense");

    private String toString(MetadataType metadataType) {
        return new MetadataTypeWriter().toString(metadataType);
    }

    private TypesCatalogBuilderContext createTypesCatalogBuilderContext() {
        Notifier notifier = new Notifier(){

            public void reportWarning(I18nMessage i18nMessage) {
                System.out.println(i18nMessage);
            }

            public void reportError(I18nMessage i18nMessage) {
                System.out.println(i18nMessage);
            }

            public void reportFatalError(I18nMessage i18nMessage) {
                System.out.println(i18nMessage);
            }
        };
        return new TypesCatalogBuilderContext(notifier, ExpressionLanguageMetadataServiceUtils.createExpressionLanguageMetadataService());
    }

    @Test
    public void typesCatalogCanBeLoadedFromJsonFile() throws Exception {
        File testFolder = new File(TESTS_FOLDER, "test-002");
        File appTypesFile = new File(testFolder, "app-types.json");
        TypesCatalogJsonLoader typesCatalogJsonLoader = new TypesCatalogJsonLoader();
        TypesCatalog typesCatalog = typesCatalogJsonLoader.loadFiles(Collections.singletonList(appTypesFile), this.createTypesCatalogBuilderContext());
        Assert.assertTrue((boolean)typesCatalog.resolveType("Type1").isPresent());
        Assert.assertTrue((boolean)typesCatalog.resolveType("Type2").isPresent());
    }

    private void assertType(Optional<MetadataType> metadataTypeOptional, String expectedTypeData) {
        Assert.assertTrue((boolean)metadataTypeOptional.isPresent());
        Assert.assertThat((Object)this.toString(metadataTypeOptional.get()), (Matcher)IsEqualIgnoringWhiteSpace.equalToIgnoringWhiteSpace((String)expectedTypeData));
    }

    private MetadataType removeSchemaPath(MetadataType metadataType) {
        metadataType.getAnnotation(MetadataFormatPropertiesAnnotation.class).ifPresent(metadataFormatPropertiesAnnotation -> metadataFormatPropertiesAnnotation.getValue().remove("schemaPath"));
        return metadataType;
    }

    @Test
    public void typesCatalogCanBeLoadedFromXmlFile() throws Exception {
        File testFolder = new File(TESTS_FOLDER, "test-002");
        File appTypesFile = new File(testFolder, "app-types.xml");
        TypesCatalogXmlLoader typesCatalogXmlLoader = new TypesCatalogXmlLoader();
        TypesCatalog typesCatalog = typesCatalogXmlLoader.loadFiles(Collections.singletonList(appTypesFile), this.createTypesCatalogBuilderContext());
        this.assertType(typesCatalog.resolveType("Type1"), "%type _:Json = @typeAlias(\"value\" : \"Type1\") { \"number\"? : Number, \"street_type\"? : @enum(\"values\" : [\"Avenue\",\"Street\",\"Boulevard\"]) String, \"street_name\"? : String }");
        this.assertType(typesCatalog.resolveType("Type1WithSpace"), "%type _:Json = @typeAlias(\"value\" : \"Type1WithSpace\") { \"number\"? : Number, \"street_type\"? : @enum(\"values\" : [\"Avenue\",\"Street\",\"Boulevard\"]) String, \"street_name\"? : String }");
        this.assertType(typesCatalog.resolveType("Type2"), "%type _:Json = @label(\"value\" : \"Example Schema\") @typeAlias(\"value\" : \"Type2\") { \"firstName\" : String, \"lastName\" : String, @description(\"value\" : \"Age in years\") \"age\"? : @range(\"from\" : 0) @int Number, * : Any }");
        this.assertType(typesCatalog.resolveType("Type2_1"), "%type _:Json = @typeAlias(\"value\" : \"Type2_1\") { \"data\"? : { \"p\"? : @range(\"from\" : 0) Number, \"data\"? : { \"p\"? : @range(\"from\" : 0) Number } } }");
        this.assertType(typesCatalog.resolveType("Type3"), "%type _:Json = @typeAlias(\"value\" : \"Type3\") { \"number\"? : Number, \"street_type\"? : @enum(\"values\" : [\"Avenue\",\"Street\",\"Boulevard\"]) String, \"street_name\"? : String }");
        this.assertType(typesCatalog.resolveType("Type4"), "%type _:Json = @example(\"value\" : \"{\\\"title\\\":\\\"Example Schema\\\",\\\"type\\\":\\\"object\\\",\\\"properties\\\":{\\\"firstName\\\":{\\\"type\\\":\\\"string\\\"},\\\"lastName\\\":{\\\"type\\\":\\\"string\\\"},\\\"age\\\":{\\\"description\\\":\\\"Age in years\\\",\\\"type\\\":\\\"integer\\\",\\\"minimum\\\":0}},\\\"required\\\":[\\\"firstName\\\",\\\"lastName\\\"]}\") @typeAlias(\"value\" : \"Type4\") { \"title\" : String, \"type\" : String, \"properties\" : { \"firstName\" : { \"type\" : String }, \"lastName\" : { \"type\" : String }, \"age\" : { \"description\" : String, \"type\" : String, \"minimum\" : @typeId(\"value\" : \"int\") Number } }, \"required\" : [String] }");
        this.assertType(typesCatalog.resolveType("CsvType1"), "%type _:csv = @example(\"value\" : \"c1,c2 v1,v2\") [{ \"c1\" : String, \"c2\" : String }]");
        this.assertType(typesCatalog.resolveType("CsvType2"), "%type _:CSV = @example(\"value\" : \"c1,c2 1,v1 2,v2\") [{ \"c1\" : String, \"c2\" : String }]");
        this.assertType(typesCatalog.resolveType("CsvType3"), "%type _:csv = @example(\"value\" : \"c1,c2\") [Nothing]");
        this.assertType(typesCatalog.resolveType("CopybookType").map(this::removeSchemaPath), "%type _:Copybook = @typeAlias(\"value\" : \"CopybookType\") @schemaConstruct(\"value\" : SEGMENT) @formatProperties(\"properties\" : {segmentIdent=MR0}) [{ @description(\"value\" : \"COMPANY-NAME\") \"COMPANY-NAME\"? : String, @description(\"value\" : \"CONTACTS\") \"CONTACTS\"? : { @description(\"value\" : \"PRESIDENT\") \"PRESIDENT\"? : { @description(\"value\" : \"LAST-NAME\") \"LAST-NAME\"? : String, @description(\"value\" : \"FIRST-NAME\") \"FIRST-NAME\"? : String }, @description(\"value\" : \"VP-MARKETING\") \"VP-MARKETING\"? : { @description(\"value\" : \"LAST-NAME\") \"LAST-NAME\"? : String, @description(\"value\" : \"FIRST-NAME\") \"FIRST-NAME\"? : String }, @description(\"value\" : \"ALTERNATE-CONTACT\") \"ALTERNATE-CONTACT\"? : { @description(\"value\" : \"TITLE\") \"TITLE\"? : String, @description(\"value\" : \"LAST-NAME\") \"LAST-NAME\"? : String, @description(\"value\" : \"FIRST-NAME\") \"FIRST-NAME\"? : String } }, @description(\"value\" : \"ADDRESS\") \"ADDRESS\"? : String, @description(\"value\" : \"CITY\") \"CITY\"? : String, @description(\"value\" : \"STATE\") \"STATE\"? : String, @description(\"value\" : \"ZIP\") \"ZIP\"? : @int Number }]");
        this.assertType(typesCatalog.resolveType("FixedWidthType").map(this::removeSchemaPath), "%type _:FixedWidth = @typeAlias(\"value\" : \"FixedWidthType\") @schemaConstruct(\"value\" : SEGMENT) @formatProperties(\"properties\" : {segmentIdent=CR0}) [{ @FieldFormatAnnotation(\"width\" : 1, \"align\" : \"LEFT\") @description(\"value\" : \"TYPE-OF-NAME\") \"TYPE-OF-NAME\"? : String, @description(\"value\" : \"CUSTOMER-NAME\") \"CUSTOMER-NAME\"? : { @FieldFormatAnnotation(\"width\" : 15, \"align\" : \"LEFT\") @description(\"value\" : \"LAST-NAME\") \"LAST-NAME\"? : String, @FieldFormatAnnotation(\"width\" : 8, \"align\" : \"LEFT\") @description(\"value\" : \"FIRST-NAME\") \"FIRST-NAME\"? : String } }]");
        this.assertType(typesCatalog.resolveType("ExcelType2"), "%type _:Excel = { \"name\" : String, \"age\" : Number }");
        this.assertType(typesCatalog.resolveType("PojoType"), "%type _:Java = { \"name\" : String, \"age\" : Number }");
        this.assertType(typesCatalog.resolveType("XmlDefinedWithWeaveType"), "%type _:XML = { \"name\" : String, \"age\" : Number }");
        this.assertType(typesCatalog.resolveType("XmlDefinedWithWeaveType2"), "%type _:XML = { \"name\" : String, \"age\" : Number }");
        this.assertType(typesCatalog.resolveType("JsonDefinedWithWeaveType"), "%type _:Json = { \"name\" : String, \"age\" : Number }");
        this.assertType(typesCatalog.resolveType("JsonDefinedWithWeaveType2"), "%type _:Json = { \"name\" : String, \"age\" : Number }");
        this.assertType(typesCatalog.resolveType("JsonDefinedWithWeaveType3"), "%type _:Json = { \"name\" : String, \"age\" : Number }");
        this.assertType(typesCatalog.resolveType("JsonDefinedWithWeaveType4"), "%type _:Json = { \"name\" : String, \"age\" : Number }");
        Assert.assertFalse((boolean)typesCatalog.resolveType("Type5").isPresent());
        this.assertType(typesCatalog.resolveType("XmlShapeWithElemNoNs"), "%type _:XML = @typeId(\"value\" : \"#root:Root\") @typeAlias(\"value\" : \"XmlShapeWithElemNoNs\") { \"Root\" : @typeId(\"value\" : \"#AnonType_Root\") @description(\"lang\" : \"en\", \"value\" : \"A user with all the information\") {{ \"name\" : String, \"lastName\" : String, \"male\" : Boolean, \"age\" : Number }} }");
        this.assertType(typesCatalog.resolveType("XmlExampleWithDefaultElement"), "%type _:XML = @typeId(\"value\" : \"#root:root\") @example(\"value\" : \" &lt;root&gt; &lt;item&gt; &lt;name&gt;foo0&lt;/name&gt; &lt;description&gt;foo0&lt;/description&gt; &lt;/item&gt; &lt;item&gt; &lt;name&gt;foo1&lt;/name&gt; &lt;description&gt;foo1&lt;/description&gt; &lt;/item&gt; &lt;/root&gt; \") @typeAlias(\"value\" : \"XmlExampleWithDefaultElement\") { \"root\" : @typeId(\"value\" : \"#AnonType_root\") {{ \"item\"?* : @typeId(\"value\" : \"#AnonType_itemroot\") {{ \"name\" : @enum(\"values\" : [\"foo0\",\"foo1\"]) String, \"description\" : @enum(\"values\" : [\"foo0\",\"foo1\"]) String }} }} }");
    }

    @Test
    public void typesCatalogCanBeLoadedFromXmlFiles() throws Exception {
        File testFolder = new File(TESTS_FOLDER, "test-003");
        List<File> appTypesFiles = Arrays.asList(new File(testFolder, "app-types-1.xml"), new File(testFolder, "app-types-2.xml"));
        TypesCatalogXmlLoader typesCatalogXmlLoader = new TypesCatalogXmlLoader();
        TypesCatalog typesCatalog = typesCatalogXmlLoader.loadFiles(appTypesFiles, this.createTypesCatalogBuilderContext());
        this.assertType(typesCatalog.resolveType("Type1"), "%type _:Json = @typeAlias(\"value\" : \"Type1\") { \"number\"? : Number, \"street_type\"? : @enum(\"values\" : [\"Avenue\",\"Street\",\"Boulevard\"]) String, \"street_name\"? : String }");
        this.assertType(typesCatalog.resolveType("Type2"), "%type _:Json = @label(\"value\" : \"Example Schema\") @typeAlias(\"value\" : \"Type2\") { \"firstName\" : String, \"lastName\" : String, @description(\"value\" : \"Age in years\") \"age\"? : @range(\"from\" : 0) @int Number, * : Any }");
        this.assertType(typesCatalog.resolveType("Type3"), "%type _:Json = @typeAlias(\"value\" : \"Type3\") { \"number\"? : Number, \"street_type\"? : @enum(\"values\" : [\"Avenue\",\"Street\",\"Boulevard\"]) String, \"street_name\"? : String }");
        this.assertType(typesCatalog.resolveType("Type4"), "%type _:Json = @example(\"value\" : \"{\\\"title\\\":\\\"Example Schema\\\",\\\"type\\\":\\\"object\\\",\\\"properties\\\":{\\\"firstName\\\":{\\\"type\\\":\\\"string\\\"},\\\"lastName\\\":{\\\"type\\\":\\\"string\\\"},\\\"age\\\":{\\\"description\\\":\\\"Age in years\\\",\\\"type\\\":\\\"integer\\\",\\\"minimum\\\":0}},\\\"required\\\":[\\\"firstName\\\",\\\"lastName\\\"]}\") @typeAlias(\"value\" : \"Type4\") { \"title\" : String, \"type\" : String, \"properties\" : { \"firstName\" : { \"type\" : String }, \"lastName\" : { \"type\" : String }, \"age\" : { \"description\" : String, \"type\" : String, \"minimum\" : @typeId(\"value\" : \"int\") Number } }, \"required\" : [String] }");
        this.assertType(typesCatalog.resolveType("CsvType1"), "%type _:csv = @example(\"value\" : \"c1,c2 v1,v2\") [{ \"c1\" : String, \"c2\" : String }]");
        this.assertType(typesCatalog.resolveType("CsvType2"), "%type _:CSV = @example(\"value\" : \"c1,c2 1,v1 2,v2\") [{ \"c1\" : String, \"c2\" : String }]");
        this.assertType(typesCatalog.resolveType("CsvType3"), "%type _:csv = @example(\"value\" : \"c1,c2\") [Nothing]");
        this.assertType(typesCatalog.resolveType("CopybookType").map(this::removeSchemaPath), "%type _:Copybook = @typeAlias(\"value\" : \"CopybookType\") @schemaConstruct(\"value\" : SEGMENT) @formatProperties(\"properties\" : {segmentIdent=MR0}) [{ @description(\"value\" : \"COMPANY-NAME\") \"COMPANY-NAME\"? : String, @description(\"value\" : \"CONTACTS\") \"CONTACTS\"? : { @description(\"value\" : \"PRESIDENT\") \"PRESIDENT\"? : { @description(\"value\" : \"LAST-NAME\") \"LAST-NAME\"? : String, @description(\"value\" : \"FIRST-NAME\") \"FIRST-NAME\"? : String }, @description(\"value\" : \"VP-MARKETING\") \"VP-MARKETING\"? : { @description(\"value\" : \"LAST-NAME\") \"LAST-NAME\"? : String, @description(\"value\" : \"FIRST-NAME\") \"FIRST-NAME\"? : String }, @description(\"value\" : \"ALTERNATE-CONTACT\") \"ALTERNATE-CONTACT\"? : { @description(\"value\" : \"TITLE\") \"TITLE\"? : String, @description(\"value\" : \"LAST-NAME\") \"LAST-NAME\"? : String, @description(\"value\" : \"FIRST-NAME\") \"FIRST-NAME\"? : String } }, @description(\"value\" : \"ADDRESS\") \"ADDRESS\"? : String, @description(\"value\" : \"CITY\") \"CITY\"? : String, @description(\"value\" : \"STATE\") \"STATE\"? : String, @description(\"value\" : \"ZIP\") \"ZIP\"? : @int Number }]");
        this.assertType(typesCatalog.resolveType("FixedWidthType").map(this::removeSchemaPath), "%type _:FixedWidth = @typeAlias(\"value\" : \"FixedWidthType\") @schemaConstruct(\"value\" : SEGMENT) @formatProperties(\"properties\" : {segmentIdent=CR0}) [{ @FieldFormatAnnotation(\"width\" : 1, \"align\" : \"LEFT\") @description(\"value\" : \"TYPE-OF-NAME\") \"TYPE-OF-NAME\"? : String, @description(\"value\" : \"CUSTOMER-NAME\") \"CUSTOMER-NAME\"? : { @FieldFormatAnnotation(\"width\" : 15, \"align\" : \"LEFT\") @description(\"value\" : \"LAST-NAME\") \"LAST-NAME\"? : String, @FieldFormatAnnotation(\"width\" : 8, \"align\" : \"LEFT\") @description(\"value\" : \"FIRST-NAME\") \"FIRST-NAME\"? : String } }]");
        this.assertType(typesCatalog.resolveType("ExcelType2"), "%type _:Excel = { \"name\" : String, \"age\" : Number }");
        Assert.assertFalse((boolean)typesCatalog.resolveType("Type5").isPresent());
        this.assertType(typesCatalog.resolveType("XmlShapeWithElemNoNs"), "%type _:XML = @typeId(\"value\" : \"#root:Root\") @typeAlias(\"value\" : \"XmlShapeWithElemNoNs\") { \"Root\" : @typeId(\"value\" : \"#AnonType_Root\") @description(\"lang\" : \"en\", \"value\" : \"A user with all the information\") {{ \"name\" : String, \"lastName\" : String, \"male\" : Boolean, \"age\" : Number }} }");
    }
}

