/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.enrichment;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.xml.parsers.ParserConfigurationException;
import org.mule.datasense.catalog.builder.TypesCatalogBuilderContext;
import org.mule.datasense.catalog.loader.xml.TypesCatalogXmlLoader;
import org.mule.datasense.catalog.model.TypesCatalog;
import org.mule.datasense.common.loader.xml.XmlUtils;
import org.mule.datasense.common.util.Notifier;
import org.mule.datasense.declarations.loader.TypeDeclarationLoaderContext;
import org.mule.datasense.declarations.loader.xml.TypeDeclarationXmlLoader;
import org.mule.datasense.enrichment.loader.ComponentModelEnrichmentLoaderContext;
import org.mule.datasense.enrichment.loader.xml.ComponentModelEnrichmentXmlLoader;
import org.mule.datasense.enrichment.model.ComponentModelEnrichments;
import org.mule.datasense.util.ExpressionLanguageMetadataServiceUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.internal.utils.MetadataTypeWriter;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class BaseTypeDeclarationsTest {
    static final transient Logger logger = LoggerFactory.getLogger(BaseTypeDeclarationsTest.class);
    static final File TESTS_FOLDER = new File("src/test/resources/datasense");
    private final AstXmlParser astXmlParser = AstXmlParser.builder().build();

    <T> TypeDeclarationsHelper<T> createTypeDeclarationsHelper(File appFile, List<File> appTypesFiles, Notifier notifier, TypeDeclarationXmlLoader<T, Element> typeDeclarationLoader) throws Exception {
        ArtifactAst applicationModel = this.loadApplicationModel(appFile);
        TypesCatalog typesCatalog = this.loadTypesCatalog(notifier, appTypesFiles);
        ComponentModelEnrichments componentModelEnrichments = new ComponentModelEnrichments();
        ComponentModelEnrichmentXmlLoader componentModelEnrichmentXmlLoader = new ComponentModelEnrichmentXmlLoader();
        for (File appTypesFile : appTypesFiles) {
            this.loadComponentModelEnrichments(componentModelEnrichmentXmlLoader, componentModelEnrichments, appTypesFile);
        }
        return new TypeDeclarationsHelper<T>(typeDeclarationLoader, applicationModel, componentModelEnrichments, typesCatalog, notifier);
    }

    private TypesCatalog loadTypesCatalog(Notifier notifier, List<File> appTypesFiles) throws Exception {
        TypesCatalogBuilderContext typesCatalogBuilderContext = new TypesCatalogBuilderContext(notifier, ExpressionLanguageMetadataServiceUtils.createExpressionLanguageMetadataService());
        return new TypesCatalogXmlLoader().loadFiles(appTypesFiles, typesCatalogBuilderContext);
    }

    private ArtifactAst loadApplicationModel(File appFile) throws FileNotFoundException {
        return this.astXmlParser.parse(new URI[]{appFile.toURI()});
    }

    private void loadComponentModelEnrichments(ComponentModelEnrichmentXmlLoader componentModelEnrichmentXmlLoader, ComponentModelEnrichments componentModelEnrichments, File appTypesFile) throws IOException, SAXException, ParserConfigurationException {
        try (FileInputStream fileInputStream = new FileInputStream(appTypesFile);){
            Element element = XmlUtils.parseRootElement((InputSource)new InputSource(fileInputStream), (boolean)true, (boolean)false);
            componentModelEnrichmentXmlLoader.load(componentModelEnrichments, element, new ComponentModelEnrichmentLoaderContext());
        }
    }

    String toString(MetadataType metadataType) {
        MetadataTypeWriter metadataTypeWriter = new MetadataTypeWriter();
        return metadataTypeWriter.toString(metadataType);
    }

    static class TypeDeclarationsHelper<T> {
        private final TypeDeclarationXmlLoader<T, Element> typeDeclarationXmlLoader;
        private final ArtifactAst applicationModel;
        private final ComponentModelEnrichments componentModelEnrichments;
        private final TypesCatalog typesCatalog;
        private final Notifier notifier;

        public TypeDeclarationsHelper(TypeDeclarationXmlLoader<T, Element> typeDeclarationXmlLoader, ArtifactAst applicationModel, ComponentModelEnrichments componentModelEnrichments, TypesCatalog typesCatalog, Notifier notifier) {
            this.typeDeclarationXmlLoader = typeDeclarationXmlLoader;
            this.applicationModel = applicationModel;
            this.componentModelEnrichments = componentModelEnrichments;
            this.typesCatalog = typesCatalog;
            this.notifier = notifier;
        }

        public T findTypeDeclaration(String id) {
            if (id == null) {
                return null;
            }
            ComponentAst componentModel = (ComponentAst)this.applicationModel.filteredComponents(cm -> id.equals(cm.getMetadata().getDocAttributes().get("id"))).findFirst().orElseThrow(() -> new AssertionError((Object)String.format("No component found with doc:id %s", id)));
            TypeDeclarationLoaderContext typeDeclarationLoaderContext = new TypeDeclarationLoaderContext(componentModel, this.typesCatalog, this.notifier);
            return this.findDeclarations(this.componentModelEnrichments, componentModel, this.typeDeclarationXmlLoader, typeDeclarationLoaderContext).orElseThrow(() -> new AssertionError((Object)String.format("No extensionOperationTypeDeclaration found for componentModel %s", componentModel.getComponentId().orElse(null))));
        }

        private <T> Optional<T> findDeclarations(ComponentModelEnrichments componentModelEnrichments, ComponentAst componentModel, TypeDeclarationXmlLoader<T, Element> typeDeclarationLoader, TypeDeclarationLoaderContext typeDeclarationLoaderContext) {
            return componentModelEnrichments.enrich(componentModel).map(o -> (Element)o).map(element -> typeDeclarationLoader.load(element, typeDeclarationLoaderContext)).filter(Optional::isPresent).map(Optional::get).findFirst();
        }
    }

    static class MyNotifier
    implements Notifier {
        private final List<String> messages = new ArrayList<String>();

        MyNotifier() {
        }

        public void reportWarning(I18nMessage i18nMessage) {
            this.report("WARN", i18nMessage);
        }

        public void reportError(I18nMessage i18nMessage) {
            this.report("ERROR", i18nMessage);
        }

        public void reportFatalError(I18nMessage i18nMessage) {
            this.report("FATAL", i18nMessage);
        }

        private void report(String notificationType, I18nMessage i18nMessage) {
            this.messages.add(String.format("[%s] %s", notificationType, i18nMessage.getMessage()));
        }

        public List<String> getMessages() {
            return this.messages;
        }
    }
}

