/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.declarations.loader.json;

import com.google.common.base.Throwables;
import com.google.gson.JsonElement;
import java.util.Optional;
import org.mule.datasense.catalog.model.resolver.TypeResolverException;
import org.mule.datasense.common.loader.json.JsonMatcher;
import org.mule.datasense.common.util.TypeUtils;
import org.mule.datasense.declarations.loader.AbstractTypeDeclarationLoader;
import org.mule.datasense.declarations.loader.TypeDeclarationLoaderContext;
import org.mule.datasense.declarations.model.ExtensionOperationTypeDeclaration;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.FunctionTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;

public class ExtensionOperationTypeDeclarationJsonLoader
extends AbstractTypeDeclarationLoader<ExtensionOperationTypeDeclaration, JsonElement> {
    @Override
    public Optional<ExtensionOperationTypeDeclaration> load(JsonElement element, TypeDeclarationLoaderContext typeDeclarationLoaderContext) {
        return JsonMatcher.match(element, "op_declaration").map(mpDeclaration -> {
            BaseTypeBuilder typeBuilder = TypeUtils.getTypeBuilder(MetadataFormat.JAVA);
            FunctionTypeBuilder functionTypeBuilder = typeBuilder.functionType();
            mpDeclaration.matchMany("inputs").ifPresent(inputs -> inputs.forEach(input -> {
                String name = input.requireString("name");
                String typeExpression = input.requireString("type");
                try {
                    functionTypeBuilder.addParameterOf(name, this.resolveType(typeExpression, typeDeclarationLoaderContext.getTypesCatalog()));
                }
                catch (TypeResolverException e) {
                    Throwables.propagate((Throwable)e);
                }
            }));
            mpDeclaration.match("outputs").ifPresent(outputEvent -> {
                MessageMetadataTypeBuilder messageMetadataTypeBuilder = new MessageMetadataTypeBuilder();
                outputEvent.match("payload").ifPresent(payload -> {
                    String typeExpression = payload.requireString("type");
                    try {
                        messageMetadataTypeBuilder.payload(this.resolveType(typeExpression, typeDeclarationLoaderContext.getTypesCatalog()));
                    }
                    catch (TypeResolverException e) {
                        Throwables.propagate((Throwable)e);
                    }
                });
                outputEvent.match("attributes").ifPresent(attributes -> {
                    String typeExpression = attributes.requireString("type");
                    try {
                        messageMetadataTypeBuilder.attributes(this.resolveType(typeExpression, typeDeclarationLoaderContext.getTypesCatalog()));
                    }
                    catch (TypeResolverException e) {
                        Throwables.propagate((Throwable)e);
                    }
                });
                functionTypeBuilder.returnType((TypeBuilder)messageMetadataTypeBuilder);
            });
            return new ExtensionOperationTypeDeclaration(functionTypeBuilder.build());
        });
    }
}

