/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.declarations.loader.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.Collections;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.datasense.catalog.model.TypesCatalog;
import org.mule.datasense.declarations.loader.TypeDeclarationLoaderContext;
import org.mule.datasense.declarations.loader.json.MessageProcessorTypeDeclarationJsonLoader;
import org.mule.datasense.declarations.model.MessageProcessorTypeDeclaration;
import org.mule.metadata.api.model.FunctionType;

public class MessageProcessorTypeDeclarationJsonLoaderTest {
    private MessageProcessorTypeDeclarationJsonLoader loader;
    private TypeDeclarationLoaderContext loaderContext;
    private TypesCatalog typesCatalog;

    @Before
    public void setup() {
        this.loader = new MessageProcessorTypeDeclarationJsonLoader();
        this.typesCatalog = new TypesCatalog(Collections.emptyList());
        this.loaderContext = new TypeDeclarationLoaderContext(null, this.typesCatalog);
    }

    @Test
    public void testEmptyDeclaration() {
        String json = "{ \"mp_declaration\": {} }";
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        Optional result = this.loader.load((JsonElement)jsonObject, this.loaderContext);
        Assert.assertTrue((String)"Should return a MessageProcessorTypeDeclaration", (boolean)result.isPresent());
        MessageProcessorTypeDeclaration declaration = (MessageProcessorTypeDeclaration)result.get();
        Assert.assertNotNull((Object)declaration.getFunctionType());
        Assert.assertTrue((boolean)(declaration.getFunctionType() instanceof FunctionType));
    }

    @Test
    public void testWithInputEvent() {
        String json = "{ \"mp_declaration\": { \"input-event\": { \"message\": {} } } }";
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        Optional result = this.loader.load((JsonElement)jsonObject, this.loaderContext);
        Assert.assertTrue((String)"Should return a MessageProcessorTypeDeclaration with input event", (boolean)result.isPresent());
        MessageProcessorTypeDeclaration declaration = (MessageProcessorTypeDeclaration)result.get();
        Assert.assertNotNull((Object)declaration.getFunctionType());
    }

    @Test
    public void testWithOutputEvent() {
        String json = "{ \"mp_declaration\": { \"output-event\": { \"message\": {} } } }";
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        Optional result = this.loader.load((JsonElement)jsonObject, this.loaderContext);
        Assert.assertTrue((String)"Should return a MessageProcessorTypeDeclaration with output event", (boolean)result.isPresent());
        MessageProcessorTypeDeclaration declaration = (MessageProcessorTypeDeclaration)result.get();
        Assert.assertNotNull((Object)declaration.getFunctionType());
    }

    @Test
    public void testWithInputAndOutputEvent() {
        String json = "{ \"mp_declaration\": { \"input-event\": { \"message\": {} }, \"output-event\": { \"message\": {} } } }";
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        Optional result = this.loader.load((JsonElement)jsonObject, this.loaderContext);
        Assert.assertTrue((String)"Should return a MessageProcessorTypeDeclaration with input and output", (boolean)result.isPresent());
        MessageProcessorTypeDeclaration declaration = (MessageProcessorTypeDeclaration)result.get();
        FunctionType functionType = declaration.getFunctionType();
        Assert.assertNotNull((Object)functionType);
        Assert.assertTrue((functionType.getParameters().size() > 0 ? 1 : 0) != 0);
        Assert.assertNotNull((Object)functionType.getReturnType());
    }

    @Test
    public void testNonMatchingJson() {
        String json = "{ \"not_mp_declaration\": {} }";
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        Optional result = this.loader.load((JsonElement)jsonObject, this.loaderContext);
        Assert.assertTrue((String)"Should not return a MessageProcessorTypeDeclaration for non-matching JSON", (!result.isPresent() ? 1 : 0) != 0);
    }
}

