/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.declarations.loader.json;

import com.google.common.base.Throwables;
import com.google.gson.JsonElement;
import java.util.Optional;
import org.mule.datasense.catalog.model.resolver.TypeResolverException;
import org.mule.datasense.common.loader.json.JsonMatcher;
import org.mule.datasense.common.util.TypeUtils;
import org.mule.datasense.declarations.loader.AbstractTypeDeclarationLoader;
import org.mule.datasense.declarations.loader.TypeDeclarationLoaderContext;
import org.mule.datasense.declarations.model.MessageProcessorTypeDeclaration;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.FunctionTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;
import org.mule.metadata.message.api.MuleEventMetadataTypeBuilder;

public class MessageProcessorTypeDeclarationJsonLoader
extends AbstractTypeDeclarationLoader<MessageProcessorTypeDeclaration, JsonElement> {
    private static final String PARAMETER_NAME = "input";

    @Override
    public Optional<MessageProcessorTypeDeclaration> load(JsonElement jsonElement, TypeDeclarationLoaderContext typeDeclarationLoaderContext) {
        return JsonMatcher.match(jsonElement, "mp_declaration").map(declaration -> {
            BaseTypeBuilder typeBuilder = TypeUtils.getTypeBuilder(MetadataFormat.JAVA);
            FunctionTypeBuilder functionTypeBuilder = typeBuilder.functionType();
            declaration.match("input-event").ifPresent(inputEvent -> {
                MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
                functionTypeBuilder.addParameterOf(PARAMETER_NAME, (TypeBuilder)muleEventMetadataTypeBuilder);
                this.loadEventMetadataType(muleEventMetadataTypeBuilder, (JsonMatcher)inputEvent, typeDeclarationLoaderContext);
            });
            declaration.match("output-event").ifPresent(outputEvent -> {
                MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder = new MuleEventMetadataTypeBuilder();
                functionTypeBuilder.returnType((TypeBuilder)muleEventMetadataTypeBuilder);
                this.loadEventMetadataType(muleEventMetadataTypeBuilder, (JsonMatcher)outputEvent, typeDeclarationLoaderContext);
            });
            return new MessageProcessorTypeDeclaration(functionTypeBuilder.build());
        });
    }

    private void loadEventMetadataType(MuleEventMetadataTypeBuilder muleEventMetadataTypeBuilder, JsonMatcher event, TypeDeclarationLoaderContext typeDeclarationLoaderContext) {
        MessageMetadataTypeBuilder messageMetadataTypeBuilder = new MessageMetadataTypeBuilder();
        muleEventMetadataTypeBuilder.message(messageMetadataTypeBuilder);
        event.match("message").ifPresent(message -> {
            message.match("payload").ifPresent(payload -> {
                String typeExpression = payload.requireString("type");
                try {
                    messageMetadataTypeBuilder.payload(this.resolveType(typeExpression, typeDeclarationLoaderContext.getTypesCatalog()));
                }
                catch (TypeResolverException e) {
                    Throwables.propagate((Throwable)e);
                }
            });
            message.match("attributes").ifPresent(attributes -> {
                String typeExpression = attributes.requireString("type");
                try {
                    messageMetadataTypeBuilder.attributes(this.resolveType(typeExpression, typeDeclarationLoaderContext.getTypesCatalog()));
                }
                catch (TypeResolverException e) {
                    Throwables.propagate((Throwable)e);
                }
            });
        });
        event.matchMany("variables").ifPresent(variables -> variables.forEach(variable -> {
            String name = variable.requireString("name");
            String typeExpression = variable.requireString("type");
            try {
                muleEventMetadataTypeBuilder.addVariable(name, this.resolveType(typeExpression, typeDeclarationLoaderContext.getTypesCatalog()));
            }
            catch (TypeResolverException e) {
                Throwables.propagate((Throwable)e);
            }
        }));
    }
}

