/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.types.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.mule.datasense.types.parser.Parsers;

public interface Parser<A> {
    public A parse(Parsers.Input var1) throws Parsers.Failure;

    default public A parse(CharSequence in) throws Parsers.Failure {
        return this.parse(new Parsers.Input(in, 0));
    }

    default public Optional<A> tryParse(CharSequence in) throws Parsers.Failure {
        return this.tryParse(new Parsers.Input(in, 0));
    }

    default public Optional<A> tryParse(Parsers.Input in) {
        int offset = in.offset;
        try {
            return Optional.of(this.parse(in));
        }
        catch (Parsers.Failure e) {
            in.offset = offset;
            return Optional.empty();
        }
    }

    default public <U> Parser<Parsers.Pair<A, U>> then(Parser<U> that) {
        return in -> new Parsers.Pair<A, A>(this.parse(in), that.parse(in));
    }

    default public <U> Parser<Parsers.Pair<A, U>> then(Supplier<Parser<U>> that) {
        return in -> this.then((Parser)that.get()).parse(in);
    }

    default public Parser<A> skip(Parser<?> that) {
        return in -> {
            A result = this.parse(in);
            that.parse(in);
            return result;
        };
    }

    default public Parser<A> skip(Supplier<Parser<?>> that) {
        return in -> this.skip((Parser)that.get()).parse(in);
    }

    default public Parser<A> or(final Parser<A> that) {
        return new Parser<A>(){

            @Override
            public A parse(Parsers.Input in) throws Parsers.Failure {
                int offset = in.offset;
                try {
                    return Parser.this.parse(in);
                }
                catch (Parsers.Failure e) {
                    in.offset = offset;
                    return that.parse(in);
                }
            }
        };
    }

    default public Parser<A> or(Supplier<Parser<A>> that) {
        return in -> this.or((Parser)that.get()).parse(in);
    }

    default public Parser<Optional<A>> optional() {
        return in -> {
            try {
                return Optional.of(this.parse(in));
            }
            catch (Parsers.Failure e) {
                return Optional.empty();
            }
        };
    }

    default public Parser<List<A>> zeroOrMore() {
        return in -> {
            Optional<A> element;
            ArrayList<A> result = new ArrayList<A>();
            while ((element = this.tryParse(in)).isPresent()) {
                result.add(element.get());
            }
            return result;
        };
    }

    default public Parser<List<A>> zeroOrMore(Parser<?> separator) {
        return in -> {
            ArrayList<A> result = new ArrayList<A>();
            Optional<A> element = this.tryParse(in);
            if (element.isPresent()) {
                result.add(element.get());
                while (separator.tryParse(in).isPresent()) {
                    result.add(this.parse(in));
                }
            }
            return result;
        };
    }

    default public Parser<List<A>> oneOrMore() {
        return in -> {
            Optional<A> element;
            ArrayList<A> result = new ArrayList<A>();
            result.add(this.parse(in));
            while ((element = this.tryParse(in)).isPresent()) {
                result.add(element.get());
            }
            return result;
        };
    }

    default public Parser<List<A>> oneOrMore(Parser<?> separator) {
        return in -> {
            ArrayList<A> result = new ArrayList<A>();
            result.add(this.parse(in));
            while (separator.tryParse(in).isPresent()) {
                result.add(this.parse(in));
            }
            return result;
        };
    }

    default public Parser<List<A>> twoOrMore(Parser<?> separator) {
        return in -> {
            ArrayList<A> result = new ArrayList<A>();
            result.add(this.parse(in));
            separator.parse(in);
            result.add(this.parse(in));
            while (separator.tryParse(in).isPresent()) {
                result.add(this.parse(in));
            }
            return result;
        };
    }

    default public Parser<A> filter(Predicate<A> f) {
        return in -> {
            A result = this.parse(in);
            if (!f.test(result)) {
                throw Parsers.Failure.exception;
            }
            return result;
        };
    }

    default public <U> Parser<U> map(Function<A, U> f) {
        return in -> f.apply(this.parse(in));
    }

    default public <U> Parser<U> flatMap(Function<A, Parser<U>> f) {
        return in -> ((Parser)f.apply(this.parse(in))).parse(in);
    }
}

