package org.mule.datasense.catalog.model.resolver;

import com.google.common.base.Preconditions;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;

import java.util.Optional;

public class ExampleTypeResolver implements TypeResolver {

  private String typeIdentifier;
  private String format;
  private final TypeLoader typeLoader;

  public ExampleTypeResolver(String typeIdentifier, String format, TypeLoader typeLoader) {
    Preconditions.checkNotNull(typeLoader);
    Preconditions.checkNotNull(format);
    this.typeLoader = typeLoader;
    this.format = format;
    this.typeIdentifier = typeIdentifier;
  }

  @Override
  public Optional<MetadataType> resolveType(String typeIdentifier) {
    return typeLoader.load(this.typeIdentifier, typeIdentifier);
  }
}
