package org.mule.datasense.enrichment.model;

import org.mule.runtime.ast.api.ComponentAst;

import java.util.Optional;

public class ComponentModelEnrichment {

  private final ComponentModelSelector componentModelSelector;
  private final Object enrichmentComponentModel;

  public ComponentModelEnrichment(ComponentModelSelector componentModelSelector, Object enrichmentComponentModel) {
    this.componentModelSelector = componentModelSelector;
    this.enrichmentComponentModel = enrichmentComponentModel;
  }

  public Optional<Object> enrich(ComponentAst componentModel) {
    return componentModelSelector.match(componentModel) ? Optional.of(enrichmentComponentModel) : Optional.empty();
  }
}
