/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.catalog.model.resolver;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.mule.datasense.catalog.model.resolver.ExampleTypeResolver;
import org.mule.datasense.catalog.model.resolver.ShapeTypeResolver;
import org.mule.datasense.catalog.model.resolver.TypeResolver;
import org.mule.datasense.catalog.model.resolver.TypeResolverException;
import org.mule.metadata.api.model.MetadataType;

public class SingleTypeResolver
implements TypeResolver {
    private final String format;
    private String typeIdentifier;
    private TypeResolver shapeTypeResolver;
    private TypeResolver exampleTypeResolver;

    public SingleTypeResolver(String typeIdentifier, String format, ShapeTypeResolver shapeTypeResolver, ExampleTypeResolver exampleTypeResolver) {
        Preconditions.checkNotNull((Object)typeIdentifier);
        Preconditions.checkNotNull((Object)format);
        this.typeIdentifier = typeIdentifier;
        this.format = format;
        this.shapeTypeResolver = shapeTypeResolver;
        this.exampleTypeResolver = exampleTypeResolver;
    }

    private TypeResolver getTypeResolver() {
        return this.shapeTypeResolver != null ? this.shapeTypeResolver : this.exampleTypeResolver;
    }

    @Override
    public Optional<MetadataType> resolveType(String typeIdentifier) throws TypeResolverException {
        if (!this.typeIdentifier.equals(typeIdentifier)) {
            return Optional.empty();
        }
        return Optional.of(this.getTypeResolver().resolveType(typeIdentifier).orElseThrow(() -> new TypeResolverException("Failed to resolve type " + typeIdentifier)));
    }
}

