package org.mule.datasense.catalog.model.resolver.loaders;

import org.mule.metadata.MetadataFormats;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.dw.DwBasedShapeTypeLoader;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

import java.io.File;

public class CsvFromDwShapeTypeLoaderFactory implements ShapeTypeLoaderFactory {

  private static MetadataFormat FORMAT = MetadataFormats.CSV;
  private final ExpressionLanguageMetadataService expressionLanguageMetadataService;

  public CsvFromDwShapeTypeLoaderFactory(
                                         ExpressionLanguageMetadataService expressionLanguageMetadataService) {
    this.expressionLanguageMetadataService = expressionLanguageMetadataService;
  }

  @Override
  public String getTypeFormat() {
    return FORMAT.getId();
  }

  @Override
  public String getLoaderFormat() {
    return MetadataFormats.DW.getId();
  }

  @Override
  public TypeLoader createTypeLoader(File file) {
    return new DwBasedShapeTypeLoader(file, expressionLanguageMetadataService) {

      @Override
      protected MetadataFormat getMetadataFormat() {
        return FORMAT;
      }
    };
  }

  @Override
  public TypeLoader createTypeLoader(String content) {
    return new DwBasedShapeTypeLoader(content, expressionLanguageMetadataService) {

      @Override
      protected MetadataFormat getMetadataFormat() {
        return FORMAT;
      }
    };
  }
}
