package org.mule.datasense.catalog.model.resolver.loaders;

import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.json.api.JsonTypeLoader;

import java.io.File;

public class JsonSchemaTypeLoaderFactory implements ShapeTypeLoaderFactory {

  @Override
  public String getTypeFormat() {
    return MetadataFormat.JSON.getId();
  }

  @Override
  public String getLoaderFormat() {
    return "json-schema";
  }

  @Override
  public TypeLoader createTypeLoader(File file) {
    return new JsonTypeLoader(file);
  }

  @Override
  public TypeLoader createTypeLoader(String content) {
    return new JsonTypeLoader(content);
  }
}
