package org.mule.datasense.common.loader.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;

import java.util.Optional;
import java.util.stream.Stream;

class JsonObjectStrategy implements JsonMatcherStrategy {

  private JsonObject jsonObject;

  public JsonObjectStrategy(JsonObject jsonObject) {
    this.jsonObject = jsonObject;
  }

  @Override
  public Optional<JsonMatcher> match(String name) {
    return JsonMatcher.createMatcher(jsonObject.get(name));
  }

  @Override
  public Optional<Stream<JsonMatcher>> matchMany(String name) {
    final JsonElement jsonElement = jsonObject.get(name);
    if (jsonElement instanceof JsonArray) {
      return Optional.of(
                         JsonMatcher.jsonArrayStream((JsonArray) jsonElement)
                             .map(jsonElement1 -> JsonMatcher.createRequiredMatcher(jsonElement1)));
    } else {
      return Optional.empty();
    }
  }

  @Override
  public Optional<Stream<JsonMatcher>> matchMany() {
    throw new IllegalStateException();
  }

  @Override
  public Optional<JsonPrimitive> matchAttribute(String name) {
    final JsonElement jsonElement = jsonObject.get(name);
    if (jsonElement == null) {
      return Optional.empty();
    } else {
      if (jsonElement instanceof JsonPrimitive) {
        return Optional.of((JsonPrimitive) jsonElement);
      } else {
        throw new IllegalStateException();
      }
    }
  }

  @Override
  public JsonElement element() {
    return jsonObject;
  }
}
