/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.catalog.model;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.List;
import java.util.Optional;
import org.mule.datasense.catalog.model.resolver.TypeResolver;
import org.mule.datasense.catalog.model.resolver.TypeResolverException;
import org.mule.metadata.api.model.MetadataType;

public class TypesCatalog
implements TypeResolver {
    private final List<TypeResolver> typeResolvers;

    public TypesCatalog(List<TypeResolver> typeResolvers) {
        Preconditions.checkNotNull(typeResolvers);
        this.typeResolvers = typeResolvers;
    }

    @Override
    public Optional<MetadataType> resolveType(String typeIdentifier) throws TypeResolverException {
        try {
            return this.typeResolvers.stream().map(typeResolver -> {
                try {
                    return typeResolver.resolveType(typeIdentifier);
                }
                catch (TypeResolverException e) {
                    Throwables.propagate((Throwable)e);
                    return null;
                }
            }).filter(Optional::isPresent).map(Optional::get).findFirst();
        }
        catch (Exception e) {
            Throwable rootCause = Throwables.getRootCause((Throwable)e);
            if (rootCause instanceof TypeResolverException) {
                throw (TypeResolverException)rootCause;
            }
            throw new TypeResolverException(rootCause);
        }
    }
}

