package org.mule.datasense.catalog.model.resolver;

import org.mule.datasense.catalog.model.resolver.loaders.CopybookTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.CsvFromDwShapeTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.CsvTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.ExcelFromDwShapeTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.FixedWidthTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.FlatFileTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.FromDwShapeTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.JavaFromDwShapeTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.JavaTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.JsonSchemaTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.MapTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.ShapeTypeLoaderFactory;
import org.mule.datasense.catalog.model.resolver.loaders.TypeLoaderRegistry;
import org.mule.datasense.catalog.model.resolver.loaders.XmlSchemaTypeLoaderFactory;
import org.mule.metadata.MetadataFormats;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;

public class ShapeTypeLoaderRegistry extends TypeLoaderRegistry {

  public ShapeTypeLoaderRegistry(
                                 ExpressionLanguageMetadataService expressionLanguageMetadataService) {
    super(ShapeTypeLoaderFactory.class);

    register(new JsonSchemaTypeLoaderFactory());
    register(new XmlSchemaTypeLoaderFactory());
    register(new JavaTypeLoaderFactory());
    register(new CsvTypeLoaderFactory());
    register(new MapTypeLoaderFactory());
    register(new CopybookTypeLoaderFactory());
    register(new FixedWidthTypeLoaderFactory());
    register(new FlatFileTypeLoaderFactory());
    register(new CsvFromDwShapeTypeLoaderFactory(expressionLanguageMetadataService));
    register(new ExcelFromDwShapeTypeLoaderFactory(expressionLanguageMetadataService));
    register(new JavaFromDwShapeTypeLoaderFactory(expressionLanguageMetadataService));
    register(new FromDwShapeTypeLoaderFactory(MetadataFormats.XML, expressionLanguageMetadataService));
    register(new FromDwShapeTypeLoaderFactory(MetadataFormats.JSON, expressionLanguageMetadataService));
  }

  @Override
  public String getName() {
    return "shape";
  }
}
