package org.mule.datasense.declarations.loader.json;

import org.mule.datasense.catalog.model.resolver.TypeResolverException;
import org.mule.datasense.common.loader.json.JsonMatcher;
import org.mule.datasense.common.util.TypeUtils;
import org.mule.datasense.declarations.loader.AbstractTypeDeclarationLoader;
import org.mule.datasense.declarations.loader.TypeDeclarationLoaderContext;
import org.mule.datasense.declarations.model.ExtensionOperationTypeDeclaration;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.FunctionTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;

import com.google.common.base.Throwables;
import com.google.gson.JsonElement;

import java.util.Optional;

public class ExtensionOperationTypeDeclarationJsonLoader
    extends AbstractTypeDeclarationLoader<ExtensionOperationTypeDeclaration, JsonElement> {

  @Override
  public Optional<ExtensionOperationTypeDeclaration> load(JsonElement element,
                                                          TypeDeclarationLoaderContext typeDeclarationLoaderContext) {
    return JsonMatcher.match(element, "op_declaration").map(mpDeclaration -> {
      final BaseTypeBuilder typeBuilder = TypeUtils.getTypeBuilder(MetadataFormat.JAVA);
      final FunctionTypeBuilder functionTypeBuilder = typeBuilder.functionType();
      mpDeclaration.matchMany("inputs").ifPresent(inputs -> {
        inputs.forEach(input -> {
          final String name = input.requireString("name");
          final String typeExpression = input.requireString("type");
          try {
            functionTypeBuilder
                .addParameterOf(name, resolveType(typeExpression, typeDeclarationLoaderContext.getTypesCatalog()));
          } catch (TypeResolverException e) {
            Throwables.propagate(e);
          }
        });
      });
      mpDeclaration.match("outputs").ifPresent(outputEvent -> {
        MessageMetadataTypeBuilder messageMetadataTypeBuilder = new MessageMetadataTypeBuilder();
        outputEvent.match("payload").ifPresent(payload -> {
          final String typeExpression = payload.requireString("type");
          try {
            messageMetadataTypeBuilder
                .payload(resolveType(typeExpression, typeDeclarationLoaderContext.getTypesCatalog()));
          } catch (TypeResolverException e) {
            Throwables.propagate(e);
          }

        });
        outputEvent.match("attributes").ifPresent(attributes -> {
          final String typeExpression = attributes.requireString("type");
          try {
            messageMetadataTypeBuilder
                .attributes(resolveType(typeExpression, typeDeclarationLoaderContext.getTypesCatalog()));
          } catch (TypeResolverException e) {
            Throwables.propagate(e);
          }
        });
        functionTypeBuilder.returnType(messageMetadataTypeBuilder);
      });
      return new ExtensionOperationTypeDeclaration(functionTypeBuilder.build());
    });
  }
}
