/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl;

import com.google.common.base.Throwables;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.datasense.api.metadataprovider.ApplicationModel;
import org.mule.datasense.api.metadataprovider.DataSenseProvider;
import org.mule.datasense.catalog.builder.TypesCatalogBuilderContext;
import org.mule.datasense.catalog.loader.xml.TypesCatalogXmlLoader;
import org.mule.datasense.catalog.model.TypesCatalog;
import org.mule.datasense.common.loader.xml.XmlUtils;
import org.mule.datasense.common.util.Notifier;
import org.mule.datasense.declarations.loader.TypeDeclarationLoaderContext;
import org.mule.datasense.declarations.loader.xml.ExtensionOperationTypeDeclarationXmlLoader;
import org.mule.datasense.declarations.loader.xml.MessageProcessorTypeDeclarationXmlLoader;
import org.mule.datasense.declarations.loader.xml.TypeDeclarationXmlLoader;
import org.mule.datasense.declarations.model.ExtensionOperationTypeDeclaration;
import org.mule.datasense.declarations.model.MessageProcessorTypeDeclaration;
import org.mule.datasense.enrichment.loader.ComponentModelEnrichmentLoaderContext;
import org.mule.datasense.enrichment.loader.xml.ComponentModelEnrichmentXmlLoader;
import org.mule.datasense.enrichment.model.ComponentModelEnrichments;
import org.mule.datasense.impl.ApplicationModelResolver;
import org.mule.datasense.impl.model.ast.AstNotification;
import org.mule.datasense.impl.model.ast.MessageProcessorNode;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.config.spring.dsl.model.ComponentModel;
import org.mule.runtime.config.spring.dsl.model.DslElementModelFactory;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class DataSenseProviderResolver {
    private static final List<ComponentIdentifier> componentIdentifierBlackList = Collections.singletonList(ComponentIdentifier.builder().withNamespace("http://www.mulesoft.org/schema/mule/http").withName("listener").build());
    private final DataSenseProvider dataSenseProvider;
    private final ApplicationModelResolver applicationModelResolver;
    private final AstNotification astNotification;
    private final Notifier notifier;
    private final DslElementModelFactory dslElementModelFactory;
    private Map<String, ExtensionModel> extensionModelsByUri;
    private final TypesCatalog typesCatalog;
    private final MessageProcessorTypeDeclarationXmlLoader messageProcessorTypeDeclarationXmlLoader;
    private final ExtensionOperationTypeDeclarationXmlLoader extensionOperationTypeDeclarationXmlLoader;
    private final ComponentModelEnrichments componentModelEnrichments;

    public static boolean isDynamicDataSenseSupportedFor(MessageProcessorNode messageProcessorNode) {
        return !componentIdentifierBlackList.contains(messageProcessorNode.getComponentIdentifier());
    }

    public DataSenseProviderResolver(DataSenseProvider dataSenseProvider, ApplicationModelResolver applicationModelResolver, final AstNotification astNotification) {
        this.dataSenseProvider = dataSenseProvider;
        this.applicationModelResolver = applicationModelResolver;
        this.astNotification = astNotification;
        this.notifier = new Notifier(){

            public void reportWarning(I18nMessage i18nMessage) {
                astNotification.reportWarning(i18nMessage);
            }

            public void reportError(I18nMessage i18nMessage) {
                astNotification.reportError(i18nMessage);
            }

            public void reportFatalError(I18nMessage i18nMessage) {
                astNotification.reportFatalError(i18nMessage);
            }
        };
        this.extensionModelsByUri = new HashMap<String, ExtensionModel>();
        final Set<ExtensionModel> extensions = dataSenseProvider.getExtensions().stream().filter(Objects::nonNull).filter(extensionModel -> extensionModel.getXmlDslModel() != null).collect(Collectors.toSet());
        extensions.forEach(extensionModel -> this.extensionModelsByUri.put(extensionModel.getXmlDslModel().getNamespace(), (ExtensionModel)extensionModel));
        this.dslElementModelFactory = DslElementModelFactory.getDefault((DslResolvingContext)new DslResolvingContext(){

            public Optional<ExtensionModel> getExtension(String name) {
                return extensions.stream().filter(e -> e.getName().equals(name)).findFirst();
            }

            public Set<ExtensionModel> getExtensions() {
                return extensions;
            }

            public TypeCatalog getTypeCatalog() {
                return TypeCatalog.getDefault((Set)extensions);
            }
        });
        ApplicationModel applicationModel = applicationModelResolver.getApplicationModel();
        Optional<String> typesDataOptional = applicationModel.findTypesData();
        this.typesCatalog = typesDataOptional.map(typesData -> {
            try {
                TypesCatalogBuilderContext typesCatalogBuilderContext = new TypesCatalogBuilderContext(this.notifier);
                return new TypesCatalogXmlLoader().load(typesData, typesCatalogBuilderContext);
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
                return null;
            }
        }).orElse(null);
        this.componentModelEnrichments = typesDataOptional.flatMap(typesData -> {
            try {
                Element element = XmlUtils.parseRootElement((InputSource)new InputSource(new StringReader((String)typesData)), (boolean)true, (boolean)false);
                ComponentModelEnrichmentXmlLoader componentModelEnrichmentXmlLoader = new ComponentModelEnrichmentXmlLoader();
                return componentModelEnrichmentXmlLoader.load(element, new ComponentModelEnrichmentLoaderContext());
            }
            catch (Exception e) {
                return null;
            }
        }).orElse(null);
        this.messageProcessorTypeDeclarationXmlLoader = new MessageProcessorTypeDeclarationXmlLoader();
        this.extensionOperationTypeDeclarationXmlLoader = new ExtensionOperationTypeDeclarationXmlLoader();
    }

    public DataSenseProvider getDataSenseProvider() {
        return this.dataSenseProvider;
    }

    public ApplicationModelResolver getApplicationModelResolver() {
        return this.applicationModelResolver;
    }

    private Optional<String> getConfigurationRef(ComponentModel componentModel) {
        return Optional.ofNullable(componentModel.getParameters().get("config-ref"));
    }

    public Optional<TypesCatalog> getTypesCatalog() {
        return Optional.ofNullable(this.typesCatalog);
    }

    public Optional<ComponentModelEnrichments> getComponentModelEnrichments() {
        return Optional.ofNullable(this.componentModelEnrichments);
    }

    public Optional<ExtensionModel> findExtensionModel(ComponentModel componentModel) {
        String namespaceUri = (String)componentModel.getCustomAttributes().get("NAMESPACE_URI");
        return Optional.ofNullable(this.extensionModelsByUri.get(namespaceUri));
    }

    private Optional<ConfigurationModel> getConfigurationModel(String configuration, ExtensionModel extensionModel) {
        Optional configurationModel = Optional.empty();
        Optional<ComponentModel> namedComponent = this.getApplicationModelResolver().getApplicationModel().findNamedComponent(configuration);
        if (namedComponent.isPresent()) {
            configurationModel = extensionModel.getConfigurationModel(namedComponent.get().getIdentifier().getName());
        }
        return configurationModel;
    }

    private Optional<? extends HasSourceModels> getHasSourceModels(ComponentModel componentModel, ExtensionModel extensionModel) {
        Optional<String> configurationRef = this.getConfigurationRef(componentModel);
        return configurationRef.isPresent() ? this.getConfigurationModel(configurationRef.get(), extensionModel) : Optional.of(extensionModel);
    }

    public Optional<SourceModel> resolveSourceModel(ComponentModel componentModel) {
        ExtensionModel extensionModel;
        Optional<? extends HasSourceModels> hasSourceModels;
        Optional result = Optional.empty();
        Optional<ExtensionModel> optionalExtensionModel = this.findExtensionModel(componentModel);
        if (optionalExtensionModel.isPresent() && (hasSourceModels = this.getHasSourceModels(componentModel, extensionModel = optionalExtensionModel.get())).isPresent()) {
            result = hasSourceModels.get().getSourceModel(componentModel.getIdentifier().getName());
        }
        return result;
    }

    private Optional<? extends HasOperationModels> getHasOperationModels(ComponentModel componentModel, ExtensionModel extensionModel) {
        Optional<String> configurationRef = this.getConfigurationRef(componentModel);
        return configurationRef.isPresent() ? this.getConfigurationModel(configurationRef.get(), extensionModel) : Optional.of(extensionModel);
    }

    public Optional<OperationModel> resolveOperationModel(ComponentModel componentModel) {
        ExtensionModel extensionModel;
        Optional<? extends HasOperationModels> hasOperationModels;
        Optional result = Optional.empty();
        Optional<ExtensionModel> optionalExtensionModel = this.findExtensionModel(componentModel);
        if (optionalExtensionModel.isPresent() && (hasOperationModels = this.getHasOperationModels(componentModel, extensionModel = optionalExtensionModel.get())).isPresent()) {
            result = hasOperationModels.get().getOperationModel(componentModel.getIdentifier().getName());
        }
        return result;
    }

    public DslElementModelFactory getDslElementModelFactory() {
        return this.dslElementModelFactory;
    }

    private <T> Optional<T> findTypeDeclaration(ComponentModel componentModel, TypeDeclarationXmlLoader<T, Element> typeDeclarationLoader) {
        return this.getComponentModelEnrichments().flatMap(componentModelEnrichments1 -> componentModelEnrichments1.enrich(componentModel).map(o -> (Element)o).map(element -> typeDeclarationLoader.load(element, new TypeDeclarationLoaderContext(componentModel, this.typesCatalog, this.notifier))).filter(Optional::isPresent).map(Optional::get).findFirst());
    }

    public Optional<MessageProcessorTypeDeclaration> findMessageProcessorTypeDeclaration(ComponentModel componentModel) {
        return this.findTypeDeclaration(componentModel, (TypeDeclarationXmlLoader)this.messageProcessorTypeDeclarationXmlLoader);
    }

    public Optional<ExtensionOperationTypeDeclaration> findExtensionOperationTypeDeclaration(ComponentModel componentModel) {
        return this.findTypeDeclaration(componentModel, (TypeDeclarationXmlLoader)this.extensionOperationTypeDeclarationXmlLoader);
    }

    public AstNotification getAstNotification() {
        return this.astNotification;
    }
}

